% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataStores.R
\name{GetDataStoreTables}
\alias{GetDataStoreTables}
\title{Get all tables associated with a data store.}
\usage{
GetDataStoreTables(dataStoreId, username, password, schema = NULL)
}
\arguments{
\item{dataStoreId}{character. The ID of the data store to update.}

\item{username}{character. The username to use for authentication to the database.}

\item{password}{character. The password to use for authentication to the database.
The password is encrypted at server side and never saved or stored.}

\item{schema}{character. The name of the schema to reference. Optional.}
}
\value{
A list with the name of the catalog and the name of the tables.
}
\description{
Get all tables associated with a data store.
}
\examples{
\dontrun{
 dataStoreId <- "5c1303269300d900016b41a7"
 GetDataStoreTables(dataStoreId, username = "myUser", password = "mySecurePass129")
}
}
