% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeploymentServiceStats.R
\name{GetDeploymentServiceStats}
\alias{GetDeploymentServiceStats}
\title{Retrieve service health statistics for a deployment.}
\usage{
GetDeploymentServiceStats(
  deploymentId,
  modelId = NULL,
  start = NULL,
  end = NULL,
  executionTimeQuantile = NULL,
  responseTimeQuantile = NULL,
  slowRequestsThreshold = NULL,
  segmentAttribute = NULL,
  segmentValue = NULL
)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}

\item{modelId}{character. Optional. The ID of the model to query. If provided, only data for this
specific model will be retrieved; otherwise, data for the deployment's default model will be
retrieved.}

\item{start}{POSIXct. Optional. The start time of the reporting period for monitoring data.
Defaults to seven days prior to the end of the period. Sub-hour resolution is not permitted,
and the timezone must be \code{UTC}.}

\item{end}{POSIXct. Optional. The end time of the reporting period for monitoring data. Defaults
to the next top of the hour. Sub-hour resolution is not permitted, and the timezone must be
\code{UTC}.}

\item{executionTimeQuantile}{numeric. Optional. Quantile for the \code{executionTime} metric. Defaults
to 0.5.}

\item{responseTimeQuantile}{numeric. Optional. Quantile for the \code{responseTime} metric. Defaults
to 0.5.}

\item{slowRequestsThreshold}{integer. Optional. Threshold for the \code{slowRequests} metric.
Defaults to 1000.}

\item{segmentAttribute}{character. Optional. The name of an attribute used for segment analysis.
See \code{SegmentAnalysisAttribute} for permitted values. Added in DataRobot 2.20.}

\item{segmentValue}{character. Optional. The value of \code{segmentAttribute}. Added in DataRobot
2.20.}
}
\value{
An object representing service health metrics for the deployment, containing:
\itemize{
\item modelId character. The ID of the deployment model for which monitoring data was
retrieved.
\item period list. The duration of the reporting period, containing:
\itemize{
\item start POSIXct. Start of the reporting period.
\item end POSIXct. End of the reporting period.
}
\item metrics list. Service health metrics for the deployment, containing:
\itemize{
\item totalPredictions integer. Total number of prediction rows.
\item totalRequests integer. Total number of prediction requests performed.
\item slowRequests integer. Number of requests with response time greater than
\code{slowRequestsThreshold}.
\item responseTime numeric. Request response time at \code{responseTimeQuantile} in
milliseconds. May be NA.
\item executionTime numeric. Request execution time at \code{executionTimeQuantile} in
milliseconds. May be NA.
\item medianLoad integer. Median request rate, in requests per minute.
\item peakLoad integer. Greatest request rate, in requests per minute.
\item userErrorRate numeric. Ratio of user errors to the total number of requests.
\item serverErrorRate numeric. Ratio of server errors to the total number of requests.
\item numConsumers integer. Number of unique users performing requests.
\item cacheHitRatio numeric. The ratio of cache hits to requests.
}
\item segmentAttribute character. Added in DataRobot 2.20. The name of the segment on which
segment analysis was performed.
\item segmentValue character. Added in DataRobot 2.20. The value of the segmentAttribute.
}
}
\description{
Retrieve service health statistics for a deployment.
}
\examples{
\dontrun{
  deploymentId <- "59a5af20c80891534e3c2bde"
  startTime = ISOdate(2020, 12, 25, 1, 0, 0, tz = "UTC")
  endTime = ISOdate(2021, 01, 06, 1, 0, 0, tz = "UTC")
  GetDeploymentServiceStats(deploymentId, startTime, endTime)
}
\dontrun{
  deploymentId <- "59a5af20c80891534e3c2bde"
  GetDeploymentServiceStats(deploymentId,
                            segmentAttribute = SegmentAnalysisAttribute$DataRobotRemoteIP,
                            segmentValue = "192.168.0.1")
}
}
