test_that("robust_distances returns correct dimensions and non-negative values", {
  data("Data_HC_contamination", package = "dbrobust")
  Data_small <- Data_HC_contamination[1:50, ]

  cont_vars <- c("V1","V2","V3","V4")
  bin_vars  <- c("V8","V9")
  cat_vars  <- c("V5","V6","V7")
  w <- Data_small$w_loop

  # Test Gower
  D2_gower <- robust_distances(
    data = Data_small,
    cont_vars = cont_vars,
    bin_vars = bin_vars,
    cat_vars = cat_vars,
    w = w,
    alpha = 0.1,
    method = "ggower"
  )
  expect_equal(dim(D2_gower), c(nrow(Data_small), nrow(Data_small)))
  expect_true(all(D2_gower >= 0))

  # Test RelMS
  D2_relms <- robust_distances(
    data = Data_small,
    cont_vars = cont_vars,
    bin_vars = bin_vars,
    cat_vars = cat_vars,
    w = w,
    alpha = 0.1,
    method = "relms"
  )
  expect_equal(dim(D2_relms), c(nrow(Data_small), nrow(Data_small)))
  expect_true(all(D2_relms >= 0))
})
