% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_wrappers.R
\name{mdl_xgboost}
\alias{mdl_xgboost}
\title{Wrapper for \code{\link[xgboost:xgboost]{xgboost::xgboost()}}.}
\usage{
mdl_xgboost(y, X, nrounds = 500, verbosity = 0, ...)
}
\arguments{
\item{y}{The outcome variable.}

\item{X}{The (sparse) feature matrix.}

\item{nrounds}{Number of boosting iterations / rounds.

Note that the number of default boosting rounds here is not automatically tuned, and different
problems will have vastly different optimal numbers of boosting rounds.}

\item{verbosity}{Verbosity of printing messages. Valid values of 0 (silent), 1 (warning),
2 (info), and 3 (debug).}

\item{...}{Additional arguments passed to \code{xgboost}. See
\code{\link[xgboost:xgboost]{xgboost::xgboost()}} for a complete list of arguments.}
}
\value{
\code{mdl_xgboost} returns an object of S3 class \code{mdl_xgboost}
as a simple mask to the return object of \code{\link[xgboost:xgboost]{xgboost::xgboost()}}.
}
\description{
Simple wrapper for \code{\link[xgboost:xgboost]{xgboost::xgboost()}} with some changes to the
default arguments.
}
\examples{
xgboost_fit <- mdl_xgboost(rnorm(50), matrix(rnorm(150), 50, 3),
                           nrounds = 1)
class(xgboost_fit)
}
\references{
Chen T, Guestrin C (2011). "Xgboost: A Scalable Tree Boosting System."
Proceedings of the 22nd ACM SIGKDD International Conference on Knowledge
Discovery and Data Mining, 785–794.
}
\seealso{
\code{\link[xgboost:xgboost]{xgboost::xgboost()}}

Other ml_wrapper: 
\code{\link{mdl_glm}()},
\code{\link{mdl_glmnet}()},
\code{\link{mdl_ranger}()},
\code{\link{ols}()}
}
\concept{ml_wrapper}
