% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{clusters}
\alias{clusters}
\title{Potential droplet clusters for a plate type}
\usage{
clusters(plate)
}
\arguments{
\item{plate}{a ddPCR plate.}
}
\value{
A character vector with the names of the clusters supported by the
plate type.
}
\description{
Each ddPCR plate type has a specific set of potential clusters the droplets
can be assigned to.
}
\details{
\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on plate types.
}
\examples{
\dontrun{
dir <- sample_data_dir()
new_plate(dir) \%>\% clusters
new_plate(dir, plate_types$fam_positive_pnpp) \%>\% clusters
}
}
