% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rates_through_time.R
\name{plot_rates_through_time}
\alias{plot_rates_through_time}
\title{Plot evolution of diversification rates in relation to trait values over time}
\usage{
plot_rates_through_time(
  deepSTRAPP_outputs,
  rate_type = "net_diversification",
  quantile_ranges = c(0, 0.25, 0.5, 0.75, 1),
  select_trait_levels = "all",
  time_range = NULL,
  color_scale = NULL,
  colors_per_levels = NULL,
  plot_CI = FALSE,
  CI_type = "fuzzy",
  CI_quantiles = 0.95,
  display_plot = TRUE,
  PDF_file_path = NULL,
  return_mean_data_per_samples_df = FALSE,
  return_median_data_across_samples_df = FALSE
)
}
\arguments{
\item{deepSTRAPP_outputs}{List of elements generated with \code{\link[=run_deepSTRAPP_over_time]{run_deepSTRAPP_over_time()}},
that summarize the results of multiple STRAPP tests across \verb{$time_steps}. The list needs to include two data.frame:
\verb{$trait_data_df_over_time} and \verb{$diversification_data_df_over_time} by setting \code{extract_trait_data_melted_df = TRUE}
and \code{extract_diversification_data_melted_df = TRUE}.}

\item{rate_type}{A character string specifying the type of diversification rates to use.
Must be one of 'speciation', 'extinction' or 'net_diversification' (default).
Even if the \code{deepSTRAPP_outputs} object was generated with \code{\link[=run_deepSTRAPP_over_time]{run_deepSTRAPP_over_time()}}
for testing another type of rates, the \verb{$trait_data_df_over_time} and \verb{$diversification_data_df_over_time} data frames
will contain data for all types of rates.}

\item{quantile_ranges}{Vector of numerical. Only for continuous trait data. Quantiles used as thresholds to group branches
by trait values. It must start with 0 and finish with 1. Default is \code{c(0, 0.25, 0.5, 0.75, 1.0)}
which produces four balanced quantile groups.}

\item{select_trait_levels}{(Vector of) character string. Only for categorical and biogeographic trait data.
To provide a list of a subset of states/ranges to plot. Names must match the ones found in
\code{deepSTRAPP_outputs$trait_data_df_over_time$trait_value}. Default is \code{all} which means all states/ranges will be plotted.}

\item{time_range}{Vector of two numerical values. Time boundaries used for the plot.
If \code{NULL} (the default), the range of data provided in \code{deepSTRAPP_outputs} will be used.}

\item{color_scale}{Vector of character string. List of colors to use to build the color scale with \code{\link[grDevices:colorRamp]{grDevices::colorRampPalette()}}
to display the quantile groups used to discretize the continuous trait data. From lowest values to highest values. Only for continuous data.
Default = \code{NULL} will use the 'Spectral' color palette in \code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}}.}

\item{colors_per_levels}{Named character string. To set the colors to use to plot rates of each state/range. Names = states/ranges; values = colors.
If \code{NULL} (default), the default ggplot2 color palette (\code{\link[scales:pal_hue]{scales::hue_pal()}}) will be used. Only for categorical and biogeographic data.}

\item{plot_CI}{Logical. Whether to plot a confidence interval (CI) based on the distribution of rates found in posterior samples. Default is \code{FALSE}.}

\item{CI_type}{Character string. To select the type of confidence interval (CI) to plot.
\itemize{
\item \code{fuzzy} (default): to overlay the evolution of rates found in all posterior samples with high transparency levels.
\item \code{quantiles_rect}: to add a polygon encompassing a proportion of the rate values found in posterior samples.
This proportion is defined with \code{CI_quantiles}.
}}

\item{CI_quantiles}{Numerical. Proportion of rate values across posterior samples encompassed by the confidence interval. Only if \code{CI_type = "quantiles_rect"}. Default is \code{0.95}.}

\item{display_plot}{Logical. Whether to display the plot generated in the R console. Default is \code{TRUE}.}

\item{PDF_file_path}{Character string. If provided, the plot will be saved in a PDF file following the path provided here. The path must end with ".pdf".}

\item{return_mean_data_per_samples_df}{Logical. Whether to include in the output the data.frame of mean rates per trait values computed for
each posterior sample at each time-step (aggregated across groups of branches based on trait data). This is used to draw the confidence interval. Default is \code{FALSE}.}

\item{return_median_data_across_samples_df}{Logical. Whether to include in the output the data.frame of median rates per trait values
across posterior samples computed for at each time-step (aggregated across groups of branches based on trait data AND posterior samples).
This is used to draw the lines on the plot. Default is \code{FALSE}.}
}
\value{
The function returns a list with at least one element.
\itemize{
\item \code{rates_TT_ggplot} An object of classes \code{gg} and \code{ggplot}. This is a ggplot that can be displayed
on the console with \code{print(output$rates_TT_ggplot)}. It corresponds to the plot being displayed on the console
when the function is run, if \code{display_plot = TRUE}, and can be further modify for aesthetics using the ggplot2 grammar.
}

Optional summary data frames:
\itemize{
\item \code{mean_data_per_samples_df} A data.frame with four columns providing the \verb{$mean_rates} observed along branches
with a similar \verb{$trait_value} (if categorical or biogeographic) or falling into the same \verb{$quantile_ranges}.
Data are extracted for each posterior sample (\verb{$BAMM_sample_ID}) at each time-step (i.e., \verb{$focal_time}).
This is used to draw the confidence interval. Included if \code{return_mean_data_per_samples_df = TRUE}.
\item \verb{$median_data_across_samples_df} A data.frame with three columns providing the \verb{$median_rates}
observed across all posterior samples in \verb{$mean_data_per_samples_df}. This is used to draw the lines on the plot.
Included if \code{return_median_data_across_samples_df = TRUE}.
}

If a \code{PDF_file_path} is provided, the function will also generate a PDF file of the plot.
}
\description{
Plot the evolution of diversification rates in relation to trait values
extracted for multiple \code{time_steps} with \code{\link[=run_deepSTRAPP_over_time]{run_deepSTRAPP_over_time()}}.

Rates are averaged across branches at each time step (i.e., \code{focal_time}).
\itemize{
\item For continuous data, branches are grouped by ranges of trait values defined by \code{quantile_ranges}.
\item For categorical data, branches are grouped by trait states.
\item For biogeographic data, branches are grouped by ranges.
}
}
\examples{

# ------ Example 1: Plot rates through time for continuous data ------ #

if (deepSTRAPP::is_dev_version())
{
  ## Load results of run_deepSTRAPP_over_time()
  data(Ponerinae_deepSTRAPP_cont_old_calib_0_40, package = "deepSTRAPP")
  ## This dataset is only available in development versions installed from GitHub.
  # It is not available in CRAN versions.
  # Use remotes::install_github(repo = "MaelDore/deepSTRAPP") to get the latest development version.

  # Visualize trait data
  hist(Ponerinae_deepSTRAPP_cont_old_calib_0_40$trait_data_df_over_time$trait_value,
     xlab = "Trait values", main = NULL)

  # Generate plot
  plotTT_continuous <- plot_rates_through_time(
     deepSTRAPP_outputs = Ponerinae_deepSTRAPP_cont_old_calib_0_40,
     quantile_ranges = c(0, 0.25, 0.5, 0.75, 1.0),
     time_range = c(0, 50), # Control range of the X-axis
     # color_scale = c("limegreen", "red"),
     plot_CI = TRUE,
     CI_type = "quantiles_rect",
     CI_quantiles = 0.9,
     display_plot = FALSE,
     # PDF_file_path = "./plotTT_continuous.pdf",
     return_mean_data_per_samples_df = TRUE,
     return_median_data_across_samples_df = TRUE)

  # Explore output
  # str(plotTT_continuous, max.level = 1)

  # Plot
  print(plotTT_continuous$rates_TT_ggplot)
  # Adjust aesthetics of plot a posteriori
  plotTT_continuous_adj <- plotTT_continuous$rates_TT_ggplot +
      ggplot2::theme(
         plot.title = ggplot2::element_text(color = "red", size = 15),
         axis.title = ggplot2::element_text(size = 14),
         axis.text = ggplot2::element_text(size = 12))
  # Plot again
  print(plotTT_continuous_adj)
}


# ------ Example 2: Plot rates through time for categorical data ------ #

if (deepSTRAPP::is_dev_version())
{
  ## Load results of run_deepSTRAPP_over_time()
  data(Ponerinae_deepSTRAPP_cat_3lvl_old_calib_0_40, package = "deepSTRAPP")
  ## This dataset is only available in development versions installed from GitHub.
  # It is not available in CRAN versions.
  # Use remotes::install_github(repo = "MaelDore/deepSTRAPP") to get the latest development version.

  # Explore trait data
  table(Ponerinae_deepSTRAPP_cat_3lvl_old_calib_0_40$trait_data_df_over_time$trait_value)

  # Set colors to use
  colors_per_states <- c("forestgreen", "sienna", "goldenrod")
  names(colors_per_states) <- c("arboreal", "subterranean", "terricolous")

  # Generate plot only for "arboreal" and "terricolous"
  plotTT_categorical <- plot_rates_through_time(
      deepSTRAPP_outputs = Ponerinae_deepSTRAPP_cat_3lvl_old_calib_0_40,
      select_trait_levels = c("arboreal", "terricolous"),
      time_range = c(0, 50),
      colors_per_levels = colors_per_states,
      plot_CI = TRUE,
      CI_type = "quantiles_rect",
      CI_quantiles = 0.9,
      display_plot = FALSE,
      # PDF_file_path = "./plotTT_categorical.pdf",
      return_mean_data_per_samples_df = TRUE,
      return_median_data_across_samples_df = TRUE)

  # Explore output
  # str(plotTT_categorical, max.level = 1)

  # Adjust aesthetics of plot a posteriori
  plotTT_categorical_adj <- plotTT_categorical$rates_TT_ggplot +
      ggplot2::theme(
         plot.title = ggplot2::element_text(size = 15),
         axis.title = ggplot2::element_text(size = 14),
         axis.text = ggplot2::element_text(size = 12))
  print(plotTT_categorical_adj)
}

# ------ Example 3: Plot rates through time for biogeographic data ------ #

if (deepSTRAPP::is_dev_version())
{
  ## Load results of run_deepSTRAPP_over_time()
  data(Ponerinae_deepSTRAPP_biogeo_old_calib_0_40, package = "deepSTRAPP")
  ## This dataset is only available in development versions installed from GitHub.
  # It is not available in CRAN versions.
  # Use remotes::install_github(repo = "MaelDore/deepSTRAPP") to get the latest development version.

  # Explore range data
  table(Ponerinae_deepSTRAPP_biogeo_old_calib_0_40$trait_data_df_over_time$trait_value)

  # Set colors to use
  colors_per_ranges <- c("mediumpurple2", "peachpuff2")
  names(colors_per_ranges) <- c("N", "O")

  plotTT_biogeographic <- plot_rates_through_time(
      deepSTRAPP_outputs = Ponerinae_deepSTRAPP_biogeo_old_calib_0_40,
      select_trait_levels = "all",
      time_range = c(0, 50),
      colors_per_levels = colors_per_ranges,
      plot_CI = TRUE,
      CI_type = "quantiles_rect",
      CI_quantiles = 0.9,
      display_plot = FALSE,
      # PDF_file_path = "./plotTT_biogeographic.pdf",
      return_mean_data_per_samples_df = TRUE,
      return_median_data_across_samples_df = TRUE)

  # Explore output
  # str(plotTT_biogeographic, max.level = 1)

  # Adjust aesthetics of plot a posteriori
  plotTT_biogeographic_adj <- plotTT_biogeographic$rates_TT_ggplot +
      ggplot2::theme(
         plot.title = ggplot2::element_text(size = 15),
         axis.title = ggplot2::element_text(size = 14),
         axis.text = ggplot2::element_text(size = 12))
  print(plotTT_biogeographic_adj)
}

}
\seealso{
\code{\link[=run_deepSTRAPP_over_time]{run_deepSTRAPP_over_time()}}

For a guided tutorial, see this vignette: \code{vignette("plot_rates_through_time", package = "deepSTRAPP")}
}
\author{
Maël Doré
}
