% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_phenoBDD.R
\name{devRateIBMparam}
\alias{devRateIBMparam}
\title{Forecast ectotherm phenology as a function of temperature and development
rate models using known parameters}
\usage{
devRateIBMparam(
  tempTS,
  timeStepTS,
  eq,
  myParam,
  numInd = 10,
  stocha,
  timeLayEggs = 1,
  adultLifeStage = 0
)
}
\arguments{
\item{tempTS}{The temperature time series (a vector).}

\item{timeStepTS}{The time step of the temperature time series (a numeric
with 1 = one day).}

\item{eq}{The name of the equation provided in the package (e.g., lactin2_95).
For backward compatibility, the name of equation can be used, however, it
is preferable to use a list object containing the names of the various
equations in character format (e.g., list("campbell_74", "lactin2_95").
See examples below.}

\item{myParam}{The known parameters for the equation (a list of list for
each life stage).}

\item{numInd}{The number of individuals for the simulation (an integer).}

\item{stocha}{The standard deviation of a Normal distribution centered on
development rate to create stochasticity among individuals (a numeric).}

\item{timeLayEggs}{The delay between emergence of adults and the time where
females lay eggs in time steps (a numeric).}

\item{adultLifeStage}{An integer to specify when the adult life stage is
tacking place so that timeLayEggs is applied. Default to 0 for
backwards compatibility with previous versions of the package.}
}
\value{
A list with three elements: the table of phenology for each individual,
   the models used (nls objects), and the time series for temperature.
}
\description{
Forecast ectotherm phenology as a function of temperature and development
rate models using known parameters
}
\details{
Please note that this function is experimental and only works for
  the briere2_99 equation.
}
\examples{
# with only one life stage
forecastX <- devRateIBMparam(
  tempTS = rnorm(n = 20, mean = 20, sd = 1),
  timeStepTS = 10,
  eq = briere2_99,
  myParam = list(
    list(
      aa = 0.0002,
      Tmin = 10,
      Tmax = 36.1,
      bb = 2.84)
  ),
  numInd = 10,
  stocha = 0.015,
  timeLayEggs = 1
)
# with two life stages
forecastXX <- devRateIBMparam(
  tempTS = rnorm(n = 20, mean = 20, sd = 1),
  timeStepTS = 10,
  eq = briere2_99,
  myParam = list(
    lifeStage01 = list(
      aa = 0.0002,
      Tmin = 10,
      Tmax = 36.1,
      bb = 2.84),
    lifeStage02 = list(
      aa = 0.0004,
      Tmin = 8,
      Tmax = 35,
      bb = 2.8)
  ),
  numInd = 10,
  stocha = 0.015,
  timeLayEggs = 1
)
# with three life stages, adult stage tacking place after the pupal stage,
# so that adultLifeStage = 2. Adult longevity was exacerbated at 15 days
# to highlight the impact on function output.
forecastXXX <- devRateIBMparam(
  tempTS = rnorm(n = 120, mean = 20, sd = 1),
  timeStepTS = 1, eq = briere2_99,
  myParam = list(
   lifeStage_larva = list(
     aa = 0.0002,
     Tmin = 10,
     Tmax = 36.1,
     bb = 2.84),
   lifeStage_pupa = list(
     aa = 0.0004,
     Tmin = 8,
     Tmax = 35,
     bb = 2.8),
   lifeStage_egg = list(
     aa = 0.0002,
     Tmin = 8,
     Tmax = 35,
     bb = 2.8)
  ),
  numInd = 5, stocha = 0.015,
  timeLayEggs = 15, adultLifeStage = 2
)
# with three life stages, and a different model equation for each life stage.
forecastXXXX <- devRateIBMparam(
  tempTS = rnorm(n = 60, mean = 20, sd = 1),
  timeStepTS = 1,
  eq = list("briere2_99", "lactin2_95", "campbell_74"),
  myParam = list(
    list(
      aa = 0.0002,
      Tmin = 10,
      Tmax = 36.1,
      bb = 2.84
    ),
    list(
      aa = 0.009,
      Tmax = 35.299,
      deltaT = 0.201,
      bb = -1.049
    ),
    list(
      aa = -0.0459,
      bb = 0.0044
    )
  ),
  numInd = 10,
  stocha = 0.015,
  timeLayEggs = 1
)
}
