% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screenshot.R
\name{screenshot}
\alias{screenshot}
\title{Take a screenshot in shiny apps}
\usage{
screenshot(inputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{the input id where the screenshot should be}

\item{session}{shiny session}
}
\value{
None. However, the screenshot results can be accessed from
shiny input
}
\description{
Take a screenshot of the whole page and save encoded
\code{DataURI} that can be accessed via \code{input[[inputId]]}.
}
\examples{
library(shiny)
library(dipsaus)
ui <- fluidPage(
  tagList(
    shiny::singleton(shiny::tags$head(
      shiny::tags$link(rel="stylesheet", type="text/css", href="dipsaus/dipsaus.css"),
      shiny::tags$script(src="dipsaus/dipsaus-dipterix-lib.js")
    ))
  ),
  actionButtonStyled('do', 'Take Screenshot'),
  compoundInput2('group', label = 'Group', components = list(
    textInput('txt', 'Enter something here')
  ))
)

server <- function(input, output, session) {
  observeEvent(input$do, {
    screenshot('screeshot_result')
  })
  observeEvent(input$screeshot_result, {
    showModal(modalDialog(
      tags$img(src = input$screeshot_result, width = '100\%')
    ))
  })
}

if(interactive()){
  shinyApp(ui, server)
}

}
