% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Germlines.R
\name{stitchRegions}
\alias{stitchRegions}
\title{\link{stitchRegions} Similar to \link{stitchVDJ} but with segment IDs 
instead of nucleotides}
\usage{
stitchRegions(
  receptor,
  v_seq,
  d_seq,
  j_seq,
  np1_length = "np1_length",
  np2_length = "np1_length",
  n1_length = "n1_length",
  p3v_length = "p3v_length",
  p5d_length = "p5d_length",
  p3d_length = "p3d_length",
  n2_length = "n2_length",
  p5j_length = "p5j_length",
  np1_aa_length = "np1_aa_length",
  np2_aa_length = "np2_aa_length",
  amino_acid = FALSE
)
}
\arguments{
\item{receptor}{row from AIRR-table containing sequence of interest}

\item{v_seq}{germline V segment sequence from \link{getGermline}}

\item{d_seq}{germline D segment sequence from \link{getGermline}}

\item{j_seq}{germline J segment sequence from \link{getGermline}}

\item{np1_length}{Column name in receptor specifying np1 segment length 
(e.g. np1_length)}

\item{np2_length}{Column name in receptor specifying np2 segment length 
(e.g. np1_length)}

\item{n1_length}{Column name in receptor specifying n1 segment length 
(experimental)}

\item{p3v_length}{Column name in receptor specifying p3v segment length 
(experimental)}

\item{p5d_length}{Column name in receptor specifying p5d segment length 
(experimental)}

\item{p3d_length}{Column name in receptor specifying p3d segment length 
(experimental)}

\item{n2_length}{Column name in receptor specifying n2 segment length 
(experimental)}

\item{p5j_length}{Column name in receptor specifying p5j segment length 
(experimental)}

\item{np1_aa_length}{Column name in receptor specifying np1 segment length 
in AA (if amino_acid=TRUE, e.g. np1_length)}

\item{np2_aa_length}{Column name in receptor specifying np2 segment length 
in AA (if amino_acid=TRUE, e.g. np1_length)}

\item{amino_acid}{Perform reconstruction on amino acid sequence (experimental)}
}
\value{
Full length germline VDJ sequence with segment IDs instead of 
nucleotides.
}
\description{
\link{stitchRegions} Similar to \link{stitchVDJ} but with segment IDs 
instead of nucleotides
}
\seealso{
\link{stitchVDJ}
}
