% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1DDS.R
\name{table1DDS}
\alias{table1DDS}
\title{Creates 1-dimensional contingency tables}
\usage{
table1DDS(xvect)
}
\arguments{
\item{xvect}{a numerical vector with discrete values - usually a factor.}
}
\value{
a list which contains two elements: 'table', the 1-dimensional table and 'message' a message which
informs about the validity of the table.
}
\description{
This function generates a 1-dimensional table where potentially disclosive cells.
(based on the set threshold) are replaced by a missing value ('NA').
}
\details{
It generates a 1-dimensional tables where valid (non-disclosive) 1-dimensional tables are defined 
as data from sources where no table cells have counts between 1 and the set threshold. When the output table
is invalid all cells but the total count are replaced by missing values. Only the total count is visible 
on the table returned to the client side. A message is also returned with the 1-dimensional; the message 
says "invalid table - invalid counts present" if the table is invalid and 'valid table' otherwise.
}
\author{
Gaye A.
}
