% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-table.R
\name{summary_table_by_targets}
\alias{summary_table_by_targets}
\title{Create a summary table using multiple rows for grouping on two target column
ideal for creating change from baseline tables}
\usage{
summary_table_by_targets(
  dt,
  target,
  treat,
  rows_by,
  indent = nbsp(n = 4L),
  .total_dt = NULL,
  pct_dec = 1,
  treat_order = NULL,
  skip_absent = TRUE
)
}
\arguments{
\item{dt}{table to perform function on}

\item{target}{vector of column names desired to obtain information on}

\item{treat}{string of treatment variable used for splitting / grouping data}

\item{rows_by}{string, grouping variable to split events by.}

\item{indent}{indent to be used for display and formatting purposes}

\item{.total_dt}{optional table for total counts to be derived}

\item{pct_dec}{decimal places for percentages}

\item{treat_order}{customise the column order of output table}

\item{skip_absent}{Logical, default TRUE. Passed to data.table::setcolorder, if treat_order includes columns not present in dt, TRUE will silently ignore them, FALSE will throw an error.}
}
\value{
data.table
}
\description{
Create a summary table using multiple rows for grouping on two target column
ideal for creating change from baseline tables
}
\examples{
adlb <- random.cdisc.data::cadlb|>dplyr::filter(AVISIT != "SCREENING")
labs <- summary_table_by_targets(adlb, c('AVAL','CHG'), 'ARM', c('PARAM','AVISIT'), '  ', NULL)
}
