% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_gov_exp_column}
\alias{add_gov_exp_column}
\title{Add Government Expenditure to Country Data}
\usage{
add_gov_exp_column(
  df,
  id_column,
  id_type = "iso3_code",
  date_column = NULL,
  target_column = "gov_exp"
)
}
\arguments{
\item{df}{A data frame containing country identifiers.}

\item{id_column}{Name of the column containing country identifiers.}

\item{id_type}{Type of country identifier. Defaults to "iso3_code".}

\item{date_column}{Optional. Name of the column containing dates for
time-specific data.}

\item{target_column}{Name of the output column. Defaults to "gov_exp".}
}
\value{
A data frame with an additional column containing government
expenditure data.
}
\description{
Add Government Expenditure to Country Data
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
# Add government expenditure
df <- data.frame(country = c("USA", "GBR", "FRA"))
result <- add_gov_exp_column(df, id_column = "country")

# With years
df <- data.frame(country = c("USA", "GBR"), year = c(2010, 2020))
result <- add_gov_exp_column(df, id_column = "country", date_column = "year")
}
\dontshow{\}) # examplesIf}
}
