% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{eg_write}
\alias{eg_write}
\title{Upload a File to Egnyte}
\usage{
eg_write(file, path, overwrite = FALSE)
}
\arguments{
\item{file}{Local path to the file to upload.}

\item{path}{The Egnyte destination path (e.g., "/Shared/Documents/file.txt").}

\item{overwrite}{If FALSE (default), the upload will fail if a file already
exists at the destination. Set to TRUE to replace existing files.}
}
\value{
The Egnyte path (invisibly).
}
\description{
Uploads a local file to Egnyte cloud storage.
}
\examples{
\dontrun{
# Upload a file
eg_write("local_report.pdf", "/Shared/Documents/report.pdf")

# Overwrite an existing file
eg_write("updated_data.csv", "/Shared/Data/data.csv", overwrite = TRUE)
}

}
