% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.r
\name{count}
\alias{count}
\title{Get counts of the number of records per index.}
\usage{
count(conn, index = NULL, type = NULL, callopts = list(), verbose = TRUE, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{Index, defaults to all indices}

\item{type}{Document type, optional}

\item{callopts}{Curl args passed on to \link[crul:verb-GET]{crul::verb-GET}}

\item{verbose}{If \code{TRUE} (default) the url call used printed to console.}

\item{...}{Further args passed on to elastic search HTTP API as parameters.}
}
\description{
Get counts of the number of records per index.
}
\details{
See docs for the count API here
\url{https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-count}

You can also get a count of documents using \code{\link[=Search]{Search()}} or
\code{\link[=Search_uri]{Search_uri()}} and setting \code{size = 0}
}
\examples{
\dontrun{
# connection setup
(x <- connect())

if (!index_exists(x, "plos")) {
  plosdat <- system.file("examples", "plos_data.json",
    package = "elastic")
  plosdat <- type_remover(plosdat)
  invisible(docs_bulk(x, plosdat))
}
if (!index_exists(x, "shakespeare")) {
  shake <- system.file("examples", "shakespeare_data_.json",
    package = "elastic")
  invisible(docs_bulk(x, shake))
}

count(x)
count(x, index='plos')
count(x, index='shakespeare')
count(x, index=c('plos','shakespeare'), q="a*")
count(x, index=c('plos','shakespeare'), q="z*")

# Curl options
count(x, callopts = list(verbose = TRUE))
}
}
