% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_univariate_stratified.R
\name{tbl_cmh}
\alias{tbl_cmh}
\title{A \{gtsummary\} wrapper function that takes a dataframe and produces crude,
stratified and Cochran-Mantel-Haenszel estimates.}
\usage{
tbl_cmh(
  data,
  case,
  exposure,
  strata,
  measure,
  obstime = NULL,
  conf.level = 0.95
)
}
\arguments{
\item{data}{A data frame}

\item{case}{Name of a variable as your outcome of interest}

\item{exposure}{Names of variables as exposures of interest.
Can be multiple variables using tidyselect syntax.}

\item{strata}{Name of a variable to be used for stratifying
results. This gives you a table of crude measure, measures for each
strata and the mantel-haeszel adjusted measure for each exposure variable}

\item{measure}{Specify what you would like to calculated, options are "OR",
"RR" or "IRR". Default is "OR". If "OR or "RR" are specified then a
woolf test for homogeneity p-value is produced. This tests whether there
is a significant difference in the estimates between strata.}

\item{obstime}{A numeric variable containing the observation time for each
individual}

\item{conf.level}{Confidence level for confidence intervals (default 0.95)}
}
\value{
A gtsummary table of class \code{"tbl_cmh"} (and \code{"gtsummary"}, \code{"tbl_stack"})
containing:
\itemize{
\item Crude estimates of association (odds ratios, risk ratios, or rate ratios)
\item Stratified estimates for each level of the stratification variable
\item Cochran–Mantel–Haenszel (CMH) adjusted estimates with 95\\% confidence intervals
\item Woolf test p-values for assessing homogeneity across strata (when applicable)
}
}
\description{
A \{gtsummary\} wrapper function that takes a dataframe and produces crude,
stratified and Cochran-Mantel-Haenszel estimates.
}
\references{
Inspired by Daniel Sjoberg,
see \href{https://github.com/ddsjoberg/gtsummary}{gtsummary github repo}
}
