% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_saver.R
\name{run_multiple}
\alias{run_multiple}
\alias{run_multiple_get_results}
\alias{make_saver}
\alias{epiworld_saver}
\title{Run multiple simulations at once}
\usage{
run_multiple(
  m,
  ndays,
  nsims,
  seed = sample.int(10000, 1),
  saver = make_saver(),
  reset = TRUE,
  verbose = TRUE,
  nthreads = 1L
)

run_multiple_get_results(
  m,
  nthreads = min(2L, parallel::detectCores()),
  freader = NULL,
  ...
)

make_saver(..., fn = "")
}
\arguments{
\item{m, ndays, seed}{See \link{run}.}

\item{nsims}{Integer. Number of replicats}

\item{saver}{An object of class \link{epiworld_saver}.}

\item{reset}{When \code{TRUE} (default,) resets the simulation.}

\item{verbose}{When \code{TRUE} (default,) prints a progress bar.}

\item{nthreads}{Integer. Number of threads (passed to \code{\link[parallel:makeCluster]{parallel::makeCluster()}}).}

\item{freader}{A function to read the files. If \code{NULL} (default,) uses
\code{utils::read.table}.}

\item{...}{Additional arguments passed to \code{freader}.}

\item{fn}{A file name pattern.}
}
\value{
\itemize{
\item In the case of \code{make_saver}, an list of class \code{epiworld_saver}.
}

\itemize{
\item The \code{run_multiple} function runs a specified number of simulations and
returns a model object of class \link{epiworld_model}.
}

\itemize{
\item The \code{run_multiple_get_results} function returns a named list with the
data specified by \code{make_saver}. Each entry will be a data.frame (default),
or the output of \code{freader}.
}
}
\description{
The \code{run_multiple} function allows running multiple simulations at once.
When available, users can take advantage of parallel computing to speed up
the process.
}
\details{
Currently, the following elements can be saved:\tabular{lll}{
   Keyword \tab Description \tab Function \cr
   \code{total_hist} \tab History of the model (total numbers per time). \tab \code{\link[=get_hist_total]{get_hist_total()}} \cr
   \code{virus_info} \tab Information about \code{viruses}. \tab  \cr
   \code{virus_hist} \tab Changes in \code{viruses}. \tab \code{\link[=get_hist_virus]{get_hist_virus()}} \cr
   \code{tool_info} \tab Information about \code{tools}. \tab  \cr
   \code{tool_hist} \tab Changes in \code{tools}. \tab \code{\link[=get_hist_tool]{get_hist_tool()}} \cr
   \code{transmission} \tab Transmission events. \tab \code{\link[=get_transmissions]{get_transmissions()}} \cr
   \code{transition} \tab Transition matrices. \tab \code{\link[=get_hist_transition_matrix]{get_hist_transition_matrix()}} \cr
   \code{reproductive} \tab Reproductive number. \tab \code{\link[=get_reproductive_number]{get_reproductive_number()}} \cr
   \code{generation} \tab Estimation of generation time. \tab \code{\link[=get_generation_time]{get_generation_time()}} \cr
   \code{active_cases} \tab Number of active cases per virus. \tab \code{\link[=get_active_cases]{get_active_cases()}} \cr
   \code{outbreak_size} \tab Size of outbreaks per virus. \tab \code{\link[=get_outbreak_size]{get_outbreak_size()}} \cr
   \code{hospitalizations} \tab Number of hospitalizations per virus/tool. \tab \code{\link[=get_hospitalizations]{get_hospitalizations()}} \cr
}

An alternative to using the default \code{utils::read.table} function is to use
\code{data.table::fread} from the \code{data.table} package. This can be done by
specifying \code{freader = data.table::fread} and passing additional arguments
(e.g., \code{nThread = 2L}) via \code{...}. This can significantly speed up the
reading process, especially for large datasets.

If the model does not have, for example, tools, then the corresponding data frame
will be empty (0 rows). A warning will be issued in this case when trying
to retrieve or plot the results.
}
\section{Data structures}{


The datasets generated by \code{run_multiple_get_results} have the following
columns:
\itemize{
\item \code{total_hist}: \code{date} (integer), \code{nviruses} (integer), \code{state} (character),
\code{counts} (integer).
\item \code{virus_info}: \code{virus_id} (integer), \code{virus} (character), \code{virus_sequence}
(character), \code{date_recorded} (integer), \code{parent} (integer)
\item \code{virus_hist}: \code{date} (integer), \code{virus_id} (integer), \code{virus} (character),
\code{n} (integer).
\item \code{tool_info}: \code{id} (integer), \code{tool_name} (character), \code{tool_sequence}
(character), \code{date_recorded} (integer).
\item \code{tool_hist}: \code{date} (integer), \code{id} (integer), \code{state} (character),
\code{n} (integer).
\item \code{transmission}: \code{date} (integer), \code{virus_id} (integer), \code{virus}
(character), \code{source_exposure_date} (integer), \code{source} (integer),
\code{target} (integer).
\item \code{transition}: \code{date} (integer), \code{from} (character), \code{to} (character),
\code{counts} (integer).
\item \code{reproductive}: \code{virus_id} (integer), \code{virus} (character), \code{source}
(integer), \code{source_exposure_date} (integer), \code{rt} (integer).
\item \code{generation}: \code{virus} (integer), \code{source} (integer), \code{source_exposure_date}
(integer), \code{generation_time} (integer).
\item \code{active_cases}: \code{date} (integer), \code{virus_id} (integer), \code{virus}
(character), \code{active_cases} (integer).
\item \code{outbreak_size}: \code{date} (integer), \code{virus_id} (integer), \code{virus}
(character), \code{outbreak_size} (integer).
\item \code{hospitalizations}: \code{date} (integer), \code{virus_id} (integer), \code{tool_id}
(integer), \code{counts} (integer), and \code{weight} (numeric).
}

An \strong{important difference} from the function \code{\link[=get_reproductive_number]{get_reproductive_number()}} is
that the returned reproductive number here includes a \code{-1} in the column
\code{source}. This is the reproductive number of the model as an agent, a number
that matches the initial number of infected agents at the start of the model.
}

\examples{
model_sir <- ModelSIRCONN(
  name = "COVID-19",
  prevalence = 0.01,
  n = 1000,
  contact_rate = 2,
  transmission_rate = 0.9, recovery_rate = 0.1
)

# Generating a saver
saver <- make_saver("total_hist", "reproductive")

# Running and printing
run_multiple(model_sir, ndays = 100, nsims = 50, saver = saver, nthreads = 2)

# Retrieving the results
ans <- run_multiple_get_results(model_sir, nthreads = 2)

head(ans$total_hist)
head(ans$reproductive)

# Plotting
multi_sir <- ans$total_hist
multi_sir <- multi_sir[multi_sir$date <= 20, ]
plot(multi_sir)

}
\concept{model-utility-functions}
