% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hex2rgb.R
\name{hex2rgb}
\alias{hex2rgb}
\title{Convert HEX color(s) to RGB numeric components}
\usage{
hex2rgb(hex)
}
\arguments{
\item{hex}{Character. A HEX color string (e.g. \code{"#FF8000"}) or a character
vector of HEX codes. No NA values allowed.}
}
\value{
If \code{hex} has length 1, a named numeric vector with elements
\code{c(r, g, b)}. If \code{hex} has length > 1, a named list where each element is
a named numeric vector for the corresponding input.
}
\description{
Convert a single HEX color string or a character vector of HEX strings to RGB
numeric components. The function accepts values with or without a leading
\verb{#}. Messaging uses \code{cli} if available and falls back to \code{message()}.
}
\examples{
hex2rgb("#FF8000")
hex2rgb(c("#FF8000", "#00FF00"))

}
