% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baier_robertson.R
\name{baier_robertson}
\alias{baier_robertson}
\alias{baier_robertson,Raster,Raster-method}
\alias{baier_robertson,character,character-method}
\alias{baier_robertson,missing,missing-method}
\title{Calculate Potential Evapotranspiration (PET) using Baier-Robertson method}
\usage{
baier_robertson(tmax, tmin, x = NULL)

\S4method{baier_robertson}{Raster,Raster}(tmax, tmin, x = NULL)

\S4method{baier_robertson}{character,character}(tmax, tmin, x = NULL)

\S4method{baier_robertson}{missing,missing}(x)
}
\arguments{
\item{tmax}{Raster* object or file path; maximum temperature (°C)}

\item{tmin}{Raster* object or file path; minimum temperature (°C)}

\item{x}{A `data.table` with columns: "lon", "lat", "date", "tmax", "tmin".}
}
\value{
RasterBrick or data.table of PET values (mm/day)
}
\description{
The function \code{baier_robertson} computes PET using the Baier and Robertson method.
}
\details{
For Raster inputs, provide raster objects or file paths for maximum (`tmax`)
 and minimum (`tmin`) temperature.For `data.table` input, provide a table with 
 columns: "lon", "lat", "date", "tmax", and "tmin".
}
\keyword{internal}
