% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_min_precision.R
\name{calc_min_precision}
\alias{calc_min_precision}
\title{Calculate the mode value at minimum precision}
\usage{
calc_min_precision(x, precision_var, tie_break = NULL, second_tie_break = NULL)
}
\arguments{
\item{x}{A vector of values for which to find the mode.}

\item{precision_var}{A vector of precision values corresponding to `x`, used to filter to minimum values.}

\item{tie_break}{Optional; a vector used as the first tie-break criterion.}

\item{second_tie_break}{Optional; a vector used as the second tie-break criterion.}
}
\value{
Returns the mode of `x` for entries with minimum `precision_var` value. If no valid entries exist, returns an empty string.
}
\description{
This function determines the mode of a variable `x`, filtered to entries with the minimum value of a specified precision vector `precision_var`.
It optionally resolves ties using one or two additional vectors for tie-breaking.
}
\examples{
x = c("apple", "apple", "banana", "banana")
precision_var = c(1, 2, 1, 2)
tie_break = c(1, 2, 1, 2)
second_tie_break = c(1, 1, 2, 1)
calc_min_precision(x, precision_var, tie_break, second_tie_break)
}
