% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ice.R
\name{plot_ice}
\alias{plot_ice}
\title{Plot ICE curves for a fastml model}
\usage{
plot_ice(object, features, data = c("train", "test"), target_class = NULL, ...)
}
\arguments{
\item{object}{A `fastml` object.}

\item{features}{Character vector of feature names to plot.}

\item{data}{Character string specifying which data to use: \code{"train"} (default) or \code{"test"}.}

\item{target_class}{For classification, which class probability to plot. If NULL (default),
uses the positive class determined by the model settings. For multiclass problems,
this shows the probability of the specified class vs all others.}

\item{...}{Additional arguments passed to `pdp::partial`.}
}
\value{
A list with two elements: `data` (the ICE data frame) and `plot` (the ggplot object).
}
\description{
Generates Individual Conditional Expectation (ICE) plots for selected features
using the `pdp` package (ggplot2 engine), and returns both the underlying data
and the plot object.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
plot_ice(model, features = "Sepal.Length")
}
}
