% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qd2dens.R
\name{qd2dens}
\alias{qd2dens}
\title{Function for converting Quantile Densities to Densities}
\usage{
qd2dens(
  qd,
  qdSup = seq(0, 1, length.out = length(qd)),
  dSup,
  useSplines = TRUE
)
}
\arguments{
\item{qd}{quantile density on qdSup}

\item{qdSup}{support for quantile domain - must begin at 0 and end at 1 (default = seq(0, 1, length.out = length(qd)))}

\item{dSup}{support for Density domain - max and min values mark the boundary of the support.}

\item{useSplines}{fit spline to the qd when doing the numerical integration (default: TRUE)}
}
\value{
dens density values on dSup
}
\description{
Function for converting Quantile Densities to Densities
}
\examples{

x <- seq(0,1,length.out =512)
y <- rep(2,length.out =512)
y.dens <- qd2dens(qd=y, qdSup = x, dSup = seq(0, 2, length.out = 512)) # should equate # 1/2

}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
