% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SqrtMedian.R
\name{SqrtMedian}
\alias{SqrtMedian}
\title{SRVF transform of warping functions}
\usage{
SqrtMedian(gam)
}
\arguments{
\item{gam}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} warping functions with \eqn{N} samples}
}
\value{
Returns a list containing \item{median}{Karcher median psi function}
\item{gam_median}{Karcher mean warping function}
\item{psi}{srvf of warping functions}
\item{vec}{shooting vectors}
}
\description{
This function calculates the srvf of warping functions with corresponding
shooting vectors and finds the median
}
\examples{
out <- SqrtMedian(simu_warp_median$warping_functions)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using fisher-rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A.,
Generative Models for Function Data using Phase and Amplitude Separation,
Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
