% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_align_functions.R
\name{multiple_align_functions}
\alias{multiple_align_functions}
\title{Group-wise function alignment to specified mean}
\usage{
multiple_align_functions(
  f,
  time,
  mu,
  lambda = 0,
  pen = "roughness",
  showplot = TRUE,
  smooth_data = FALSE,
  sparam = 25,
  parallel = FALSE,
  cores = -1,
  omethod = "DP",
  MaxItr = 20,
  iter = 2000,
  verbose = TRUE
)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{mu}{vector of size \eqn{N} that f is aligned to}

\item{lambda}{controls the elasticity (default = 0)}

\item{pen}{alignment penalty (default="roughness") options are
second derivative ("roughness"), geodesic distance from id ("geodesic"), and
norm from id ("norm")}

\item{showplot}{shows plots of functions (default = T)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{parallel}{enable parallel mode using \code{foreach} and
\code{doParallel} package (default=F)}

\item{cores}{number of cores in parallel (default=-1, means all cores)}

\item{omethod}{optimization method (DP,DP2,RBFGS,dBayes,expBayes)}

\item{MaxItr}{maximum number of iterations}

\item{iter}{bayesian number of mcmc samples (default 2000)}

\item{verbose}{verbose printing (default TRUE)}
}
\value{
Returns a fdawarp object containing \item{f0}{original functions}
\item{fn}{aligned functions - matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}
\item{qn}{aligned SRSFs - similar structure to fn}
\item{q0}{original SRSF - similar structure to fn}
\item{fmean}{function mean or median - vector of length \eqn{N}}
\item{mqn}{SRSF mean or median - vector of length \eqn{N}}
\item{gam}{warping functions - similar structure to fn}
\item{orig.var}{Original Variance of Functions}
\item{amp.var}{Amplitude Variance}
\item{phase.var}{Phase Variance}
\item{qun}{Cost Function Value}
}
\description{
This function aligns a collection of functions using the elastic square-root
slope (srsf) framework.
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using fisher-rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A.,
Generative Models for Function Data using Phase and Amplitude Separation,
Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srsf}
