% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{fm_int_multi_sampler}
\alias{fm_int_multi_sampler}
\title{Multi-domain sampler integration}
\usage{
fm_int_multi_sampler(domain, samplers, ..., extra = NULL)
}
\arguments{
\item{domain}{A list of named domains}

\item{samplers}{A named list of samplers}

\item{...}{Passed on to each \code{\link[=fm_int]{fm_int()}} call.}

\item{extra}{Optional character vector with names of variables other than the
integration domains to be included from the samplers. If \code{NULL} (default),
all additional variables are included.}
}
\value{
An object with integration points and weights
}
\description{
Combine integration over different domains
}
\examples{
fm_int_multi_sampler(
  domain = list(x = fm_mesh_1d(1:4), y = 11:12),
  samplers = tibble::tibble(
    x = rbind(c(1, 3), c(2, 4)),
    y = c(12, 11)
  )
)
}
\keyword{internal}
