% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{fm_zm}
\alias{fm_zm}
\alias{fm_zm.sf}
\alias{fm_zm.sfc}
\alias{fm_zm.list}
\alias{fm_zm.sfg}
\alias{fm_zm.numeric}
\alias{fm_zm.matrix}
\alias{fm_zm_input}
\alias{fm_zm_input.sf}
\alias{fm_zm_input.sfc}
\alias{fm_zm_input.list}
\alias{fm_zm_input.sfg}
\alias{fm_zm_input.numeric}
\alias{fm_zm_input.matrix}
\alias{fm_zm_target}
\title{Add or remove Z/M information}
\usage{
fm_zm(x, ...)

\method{fm_zm}{sf}(x, ...)

\method{fm_zm}{sfc}(x, ..., add = NULL, remove = NULL, target = NULL)

\method{fm_zm}{list}(x, ..., add = NULL, remove = NULL, target = NULL)

\method{fm_zm}{sfg}(x, ..., add = NULL, remove = NULL, target = NULL)

\method{fm_zm}{numeric}(x, ..., add = NULL, remove = NULL, target = NULL, input = NULL)

\method{fm_zm}{matrix}(x, ..., add = NULL, remove = NULL, target = NULL, input = NULL)

fm_zm_input(x, ...)

\method{fm_zm_input}{sf}(x, ...)

\method{fm_zm_input}{sfc}(x, ...)

\method{fm_zm_input}{list}(x, ...)

\method{fm_zm_input}{sfg}(x, ...)

\method{fm_zm_input}{numeric}(x, ..., input = NULL)

\method{fm_zm_input}{matrix}(x, ..., input = NULL)

fm_zm_target(input, add = NULL, remove = NULL, target = NULL)
}
\arguments{
\item{x}{An object to modify}

\item{...}{Further arguments passed to methods}

\item{add}{character; one of \code{NULL}, \code{"Z"}, \code{"M"}, or \code{"ZM"}. Specifies
which dimensions to add.}

\item{remove}{character; one of \code{NULL}, \code{"Z"}, \code{"M"}, or \code{"ZM"}. Specifies
which dimensions to remove.}

\item{target}{character; one of \code{"XY"}, \code{"XYZ"}, \code{"XYM"}, or \code{"XYZM"}.
Specifies the target dimension format. If provided, overrides \code{add} and
\code{remove}. When both \code{add} and \code{remove} are \code{NULL}, the default target is
the smallest format that can hold all the inputs without loss of
information.}

\item{input}{character or character vector; one of \code{NULL}, \code{"XY"}, \code{"XYZ"},
\code{"XYM"}, or \code{"XYZM"}.
Specifies the input dimension format. If \code{NULL} (default), the input format
is inferred from the number of columns in \code{x} (for matrices/numerics) or
from the geometry type (for \code{sfc} objects).}
}
\value{
An object of the same class as \code{x}, with modified Z/M dimensions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Add and/or remove Z and/or M information from simple feature geometries.
}
\section{Functions}{
\itemize{
\item \code{fm_zm_input()}: Find the set of distinct XY/XYZ/XYM/XYZM types

\item \code{fm_zm_target()}: Determines the target XY/XYZ/XYM/XYZM format

}}
\examples{
fm_zm(fmexample$loc_sf, add = "Z")

fm_zm_input(fmexample$loc_sf)

fm_zm_target(c("XY", "XYZ"))
fm_zm_target("XY", add = "Z")
fm_zm_target(c("XY", "XYZM"), remove = "M")

}
\seealso{
\code{\link[sf:st_zm]{sf::st_zm()}} that supports a subset of these operations.
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
