% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{test_metric}
\alias{test_metric}
\title{Test for Metric Invariance}
\usage{
test_metric(Y_mat, group_vec, argvals, npc, n_perms, alpha, progress)
}
\arguments{
\item{Y_mat}{A numeric matrix (N x M) where N is subjects, M is time points.}

\item{group_vec}{A vector of length N specifying group membership (2 groups).}

\item{argvals}{A numeric vector of length M listing the observation points.}

\item{npc}{Optional. The number of FPCs. If NULL (default), it is
determined automatically by \code{determine_npc}.}

\item{n_perms}{The number of permutations (default: 499L).}

\item{alpha}{Significance level (default: 0.05).}

\item{progress}{Boolean. Show progress bars? (default: interactive()).}
}
\value{
A list with \code{passed} (boolean), \code{p_value}, and \code{statistic}.
}
\description{
Permutation test to check if the eigenfunctions are equivalent
across groups.
}
\examples{
\donttest{
  sim <- simulate_fmi_data(N_A = 20, N_B = 20, T_points = 30)
  res <- test_metric(sim$Y_mat, sim$group_vec, sim$argvals,
                     npc = 3, n_perms = 9, alpha = 0.05, progress = FALSE)
  print(res$p_value)
}
}
