% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{hrf_daguerre_generator}
\alias{hrf_daguerre_generator}
\title{Create Daguerre HRF Basis Set}
\usage{
hrf_daguerre_generator(nbasis = 3, scale = 4)
}
\arguments{
\item{nbasis}{Number of basis functions (default: 3)}

\item{scale}{Scale parameter for the time axis (default: 4)}
}
\value{
An HRF object of class \code{c("Daguerre_HRF", "HRF", "function")}
}
\description{
Generates an HRF object using Daguerre spherical basis functions with custom parameters.
These are orthogonal polynomials that naturally decay to zero.
}
\details{
Daguerre basis functions are orthogonal polynomials on [0,Inf) with respect
to the weight function w(x) = x^2 * exp(-x). They are particularly useful
for modeling hemodynamic responses as they naturally decay to zero and can
capture various response shapes with few parameters.
}
\examples{
# Create Daguerre basis with 5 functions
custom_dag <- hrf_daguerre_generator(nbasis = 5, scale = 3)
t <- seq(0, 24, by = 0.1)
response <- evaluate(custom_dag, t)
matplot(t, response, type = "l", main = "Daguerre HRF with 5 basis functions")
}
\seealso{
\code{\link{HRF_objects}} for pre-defined HRF objects,
  \code{\link{getHRF}} for a unified interface to create HRFs
}
