% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/players.R
\name{bots}
\alias{bots}
\alias{randomBot}
\alias{easyBot}
\alias{mediumBot}
\alias{hardBot}
\title{Bot players for Four in a Row}
\usage{
randomBot(game)

easyBot(game)

mediumBot(game)

hardBot(game)
}
\arguments{
\item{game}{A \code{6x7} matrix object representing the current game board.}
}
\value{
Returns an integer between 1 and 7. Each bot only selects from the
  set of valid moves, so they won't select a column that is already full.
}
\description{
Computer players that select their next move based on various
  amounts of internal logic.
}
\section{Functions}{
\itemize{
\item \code{randomBot()}: Chooses moves randomly.

\item \code{easyBot()}: Tries to make 4 in a row, but does not consider its
opponents moves.

\item \code{mediumBot()}: Selects a move based on simple internal logic. It tries to
make 4 in a row and tries to block the opponent from winning, but does not
consider possible downstream moves.

\item \code{hardBot()}: Selects a move by looking three moves ahead (with downstream
moves selected by internal logic similar to \code{mediumBot}).

}}
\examples{
play4inaRow(randomBot, easyBot)

play4inaRow(mediumBot, hardBot)

}
