% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{fish_eye}
\alias{fish_eye}
\title{Configure Fish Eye Plugin}
\usage{
fish_eye(
  key = "fish-eye",
  trigger = c("pointermove", "click", "drag"),
  r = 120,
  maxR = NULL,
  minR = 0,
  d = 1.5,
  maxD = 5,
  minD = 0,
  scaleRBy = NULL,
  scaleDBy = NULL,
  showDPercent = TRUE,
  style = NULL,
  nodeStyle = list(label = TRUE),
  preventDefault = TRUE,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{trigger}{Method to move the fisheye: "pointermove", "click", or "drag" (string, default: "pointermove").}

\item{r}{Radius of the fisheye (number, default: 120).}

\item{maxR}{Maximum adjustable radius of the fisheye
(number, default: NULL - half of the smaller canvas dimension).}

\item{minR}{Minimum adjustable radius of the fisheye (number, default: 0).}

\item{d}{Distortion factor (number, default: 1.5).}

\item{maxD}{Maximum adjustable distortion factor (number, default: 5).}

\item{minD}{Minimum adjustable distortion factor (number, default: 0).}

\item{scaleRBy}{Method to adjust the fisheye radius: "wheel" or "drag" (string, default: NULL).}

\item{scaleDBy}{Method to adjust the fisheye distortion factor: "wheel" or "drag" (string, default: NULL).}

\item{showDPercent}{Whether to show the distortion factor value in the fisheye (boolean, default: TRUE).}

\item{style}{Style of the fisheye (list, default: NULL).}

\item{nodeStyle}{Style of nodes in the fisheye (list or JS function, default: list(label = TRUE)).}

\item{preventDefault}{Whether to prevent default events (boolean, default: TRUE).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/fisheye}.}
}
\value{
A list with the configuration settings for the fisheye plugin.
}
\description{
Creates a configuration object for the fisheye plugin in G6.
This plugin creates a fisheye lens effect that magnifies elements within a specific area.
}
\examples{
# Basic configuration
config <- fish_eye()

# Custom configuration
config <- fish_eye(
  key = "my-fisheye",
  trigger = "drag",
  r = 200,
  d = 2.5,
  scaleRBy = "wheel",
  scaleDBy = "drag",
  style = list(
    stroke = "#1890ff",
    fill = "rgba(24, 144, 255, 0.1)",
    lineWidth = 2
  ),
  nodeStyle = JS("(datum) => {
    return {
      label: true,
      labelCfg: {
        style: {
          fill: '#003a8c',
          fontSize: 14
        }
      }
    };
  }")
)
}
