% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_nuts.R
\name{map_nuts}
\alias{map_nuts}
\title{Plot NUTS Matches on a Map}
\usage{
map_nuts(
  nuts,
  map_level = 3,
  country = NULL,
  show_points = TRUE,
  border_col = "lightgrey",
  low_col = "lightgreen",
  high_col = "darkgreen",
  id_col = "black",
  uid_col = "red",
  verbose = TRUE
)
}
\arguments{
\item{nuts}{(data.frame, \strong{mandatory}) Output of \code{\link{get_nuts}}. Must include
\code{lat}, \code{lon}, and either \code{nuts} (single-level) or any of \code{nuts0..nuts3},
plus \code{year}, \code{resolution}. If both single and multi-level columns exist,
\code{map_level} selects which to display.}

\item{map_level}{(integer, optional) NUTS level to display when multiple
levels are present. One of \code{0, 1, 2, 3}. Default: \code{3}.}

\item{country}{(character, optional) Two-letter \code{CNTR_CODE} to filter the
map polygons (e.g., \code{"DE"}, \code{"FR"}). If \code{NULL}, uses all available regions.}

\item{show_points}{(logical, optional) Overlay input points. Default: \code{TRUE}.}

\item{border_col}{(character, optional) Polygon border colour. Default: \code{"lightgrey"}.}

\item{low_col}{(character, optional) Fill colour for lower frequencies. Default: \code{"lightgreen"}.}

\item{high_col}{(character, optional) Fill colour for higher frequencies. Default: \code{"darkgreen"}.}

\item{id_col}{(character, optional) Point colour for matched/nearest inputs. Default: \code{"black"}.}

\item{uid_col}{(character, optional) Point colour for unmatched inputs. Default: \code{"red"}.}

\item{verbose}{(logical, optional) Print informative messages. Default: \code{TRUE}.}
}
\value{
A \code{ggplot2} object showing a choropleth of NUTS frequencies with
optional point overlays.
}
\description{
Visualises the frequency of matched NUTS regions and (optionally) overlays
the input points (matched vs. unmatched) for validation. Works with both
single-level and multi-level (\code{level = "all"}) outputs from \code{\link{get_nuts}}.
}
\examples{
\donttest{
  res <- get_nuts(52.52, 13.405, level = 3, year = 2021, resolution = 20)
  p <- map_nuts(res, map_level = 3)
  print(p)
}
}
\seealso{
\code{\link{get_nuts}}
}
