% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSAbstractDataStore.R
\docType{class}
\name{GSAbstractDataStore}
\alias{GSAbstractDataStore}
\title{Geoserver REST API DataStore}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling a GeoServer dataStore
}
\description{
Geoserver REST API DataStore

Geoserver REST API DataStore
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSAbstractStore]{geosapi::GSAbstractStore}} -> \code{GSAbstractDataStore}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{connectionParameters}}{the list of connection parameters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSAbstractDataStore-new}{\code{GSAbstractDataStore$new()}}
\item \href{#method-GSAbstractDataStore-decode}{\code{GSAbstractDataStore$decode()}}
\item \href{#method-GSAbstractDataStore-setConnectionParameters}{\code{GSAbstractDataStore$setConnectionParameters()}}
\item \href{#method-GSAbstractDataStore-addConnectionParameter}{\code{GSAbstractDataStore$addConnectionParameter()}}
\item \href{#method-GSAbstractDataStore-setConnectionParameter}{\code{GSAbstractDataStore$setConnectionParameter()}}
\item \href{#method-GSAbstractDataStore-delConnectionParameter}{\code{GSAbstractDataStore$delConnectionParameter()}}
\item \href{#method-GSAbstractDataStore-clone}{\code{GSAbstractDataStore$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setDescription"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setDescription'><code>geosapi::GSAbstractStore$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setEnabled"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setEnabled'><code>geosapi::GSAbstractStore$setEnabled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setType"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setType'><code>geosapi::GSAbstractStore$setType()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDataStore-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDataStore-new}{}}}
\subsection{Method \code{new()}}{
initializes an abstract data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDataStore$new(
  xml = NULL,
  type = NULL,
  name = NULL,
  description = "",
  enabled = TRUE,
  connectionParameters
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link[xml2]{xml_node-class} to create object from XML}

\item{\code{type}}{the type of coverage store}

\item{\code{name}}{coverage store name}

\item{\code{description}}{coverage store description}

\item{\code{enabled}}{whether the store should be enabled or not. Default is \code{TRUE}}

\item{\code{connectionParameters}}{the list of connection parameters}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDataStore-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDataStore-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes a data store from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDataStore$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link[xml2]{xml_node-class}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSAbstractDataStore}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDataStore-setConnectionParameters"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDataStore-setConnectionParameters}{}}}
\subsection{Method \code{setConnectionParameters()}}{
Set list connection parameters. The argument should be an object
   of class \code{GSRESTEntrySet} giving a list of key/value parameter entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDataStore$setConnectionParameters(parameters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameters}}{an object of class \link{GSRESTEntrySet}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDataStore-addConnectionParameter"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDataStore-addConnectionParameter}{}}}
\subsection{Method \code{addConnectionParameter()}}{
Adds a connection parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDataStore$addConnectionParameter(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{connection parameter key}

\item{\code{value}}{connection parameter value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDataStore-setConnectionParameter"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDataStore-setConnectionParameter}{}}}
\subsection{Method \code{setConnectionParameter()}}{
Sets a connection parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDataStore$setConnectionParameter(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{connection parameter key}

\item{\code{value}}{connection parameter value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDataStore-delConnectionParameter"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDataStore-delConnectionParameter}{}}}
\subsection{Method \code{delConnectionParameter()}}{
Removes a connection parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDataStore$delConnectionParameter(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{connection parameter key}

\item{\code{value}}{connection parameter value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDataStore-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDataStore-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDataStore$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
