% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-panel-counts.R
\name{stat_panel_counts}
\alias{stat_panel_counts}
\alias{stat_group_counts}
\title{Number of observations in a plot panel}
\usage{
stat_panel_counts(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  position = "identity",
  label.x = "right",
  label.y = "top",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)

stat_group_counts(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  position = "identity",
  label.x = "right",
  label.y = "top",
  hstep = 0,
  vstep = NULL,
  digits = 2,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset. Rarely used, as you will not want to
override the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use on this layer}

\item{label.x, label.y}{\code{numeric} Coordinates (in npc units) to be used
for absolute positioning of the labels.}

\item{na.rm}{a logical indicating whether \code{NA} values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes it if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and should not inherit behaviour from the
default plot specification, e.g., \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{digits}{integer Number of digits for fraction and percent labels.}
}
\value{
A plot layer instance. Using as output \code{data} the counts of
  observations in each plot panel or per group in each plot panel.
}
\description{
\code{stat_panel_counts()} counts the number of observations in each panel.
\code{stat_group_counts()} counts the number of observations in each group.
By default they add one or more text labels to the top right corner of each
panel. Grouping is ignored by \code{stat_panel_counts()}. If no grouping
exists, the two statistics behave similarly.
}
\details{
These statistics can be used to automatically count observations in
  each panel of a plot, and by default add these counts as text labels. These
  statistics, unlike \code{stat_quadrant_counts()} requires only one of
  \emph{x} or \emph{y} aesthetics and can be used together with statistics
  that have the same requirement, like \code{stat_density()}.

  The default position of the label is in the top right corner. When using
  facets even with free limits for \emph{x} and \emph{y} axes, the location
  of the labels is consistent across panels. This is achieved by use of
  \code{geom = "text_npc"} or \code{geom = "label_npc"}. To pass the
  positions in native data units to \code{label.x} and \code{label.y}, pass
  also explicitly \code{geom = "text"}, \code{geom = "label"} or some other
  geometry that use the \emph{x} and/or \emph{y} aesthetics. A vector with
  the same length as the number of panels in the figure can be used if
  needed.
}
\note{
If a factor is mapped to \code{x} or to \code{y} aesthetics each level
  of the factor constitutes a group, in this case the default positioning and
  geom using NPC pseudo aesthetics will have to be overriden by passing
  \code{geom = "text"} and data coordinates used. The default for factors
  may change in the future.
}
\section{Computed variables}{
 Data frame with one or more rows, one for each
  group of observations for which counts are counted in \code{data}. \describe{
  \item{x,npcx}{x value of label position in data- or npc units, respectively}
  \item{y,npcy}{y value of label position in data- or npc units, respectively}
  \item{count}{number of  observations as an integer}
  \item{count.label}{number of observations as character}}

  As shown in one example below \code{\link[gginnards]{geom_debug}} can be
  used to print the computed values returned by any statistic. The output
  shown includes also values mapped to aesthetics, like \code{label} in the
  example. \code{x} and \code{y} are included in the output only if mapped.
}

\examples{

# generate artificial data with numeric x and y
set.seed(67821)
x <- 1:100
y <- rnorm(length(x), mean = 10)
group <- factor(rep(c("A", "B"), times = 50))
my.data <- data.frame(x, y, group)

# using automatically generated text labels

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_panel_counts()

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_panel_counts()

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_group_counts()

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_group_counts(label.x = "left", hstep = 0.06, vstep = 0)

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_group_counts(aes(label = after_stat(pc.label)))

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_group_counts(aes(label = after_stat(pc.label)), digits = 3)

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_group_counts(aes(label = after_stat(fr.label)))

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_group_counts(aes(label = after_stat(dec.label)))

# one of x or y can be a factor
# label.x or label.y along the factor can be set to "factor" together
# with the use of geom_text()

ggplot(mpg,
       aes(factor(cyl), hwy)) +
  stat_boxplot() +
  stat_group_counts(geom = "text",
                    label.y = 10,
                    label.x = "factor") +
  stat_panel_counts()

# Numeric values can be used to build labels with alternative formats
# Here with sprintf(), but paste() and format() also work.

ggplot(my.data, aes(x, y)) +
 geom_point() +
 stat_panel_counts(aes(label = sprintf("\%i observations",
                                       after_stat(count)))) +
 scale_y_continuous(expand = expansion(mult = c(0.05, 0.12)))

ggplot(mpg,
       aes(factor(cyl), hwy)) +
  stat_boxplot() +
  stat_group_counts(geom = "text",
                    aes(label = sprintf("(\%i)", after_stat(count))),
                    label.y = 10,
                    label.x = "factor")

ggplot(mpg,
       aes(factor(cyl), hwy)) +
  stat_boxplot() +
  stat_group_counts(aes(label = sprintf("n[\%i]~`=`~\%i",
                                        after_stat(x), after_stat(count))),
                    parse = TRUE,
                    geom = "text",
                    label.y = 10,
                    label.x = "factor") +
  stat_panel_counts(aes(label = sprintf("sum(n[i])~`=`~\%i",
                                        after_stat(count))),
                    parse = TRUE)

# label position

ggplot(my.data, aes(y)) +
  stat_panel_counts(label.x = "left") +
  stat_density(alpha = 0.5)

ggplot(my.data, aes(y, colour = group)) +
  stat_group_counts(label.y = "top") +
  stat_density(aes(fill = group), alpha = 0.3)

# The numeric value can be used as a label as is

ggplot(mpg,
       aes(factor(cyl), hwy)) +
  stat_boxplot() +
  stat_group_counts(geom = "text",
                    aes(label = after_stat(count)),
                    label.x = "factor",
                    label.y = 10) +
  annotate(geom = "text", x = 0.55, y = 10, label = "n[i]~`=`", parse = TRUE)

# We use geom_debug_group() to see the computed values

gginnards.installed <- requireNamespace("gginnards", quietly = TRUE)
if (gginnards.installed) {
  library(gginnards)

  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_panel_counts(geom = "debug_group")
}

if (gginnards.installed) {
  ggplot(my.data, aes(x, y, colour = group)) +
    geom_point() +
    stat_group_counts(geom = "debug_group")
}

}
\seealso{
Other Functions for quadrant and volcano plots: 
\code{\link{geom_quadrant_lines}()},
\code{\link{stat_quadrant_counts}()}
}
\concept{Functions for quadrant and volcano plots}
