% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gipsmult_class.R
\name{get_probabilities_from_gipsmult}
\alias{get_probabilities_from_gipsmult}
\title{Extract probabilities for \code{gipsmult} object optimized with \code{return_probabilities = TRUE}}
\usage{
get_probabilities_from_gipsmult(g)
}
\arguments{
\item{g}{An object of class \code{gipsmult}.
A result of a \code{find_MAP(return_probabilities = TRUE)}.}
}
\value{
Returns a numeric vector, calculated values of probabilities.
Names contain permutations this probabilities represent.
For \code{gipsmult} object optimized with \code{find_MAP(return_probabilities = FALSE)},
it returns a \code{NULL} object.
It is sorted according to the probability.
}
\description{
After the \code{gipsmult} object was optimized with
the \code{find_MAP(return_probabilities = TRUE)} function, then
those calculated probabilities can be extracted with this function.
}
\examples{
Ss <- list(
  matrix(c(1, 0.5, 0.5, 2), nrow = 2, byrow = TRUE),
  matrix(c(2, 1, 3, 7), nrow = 2, byrow = TRUE)
)
noo <- c(10, 13)
g <- gipsmult(Ss, noo)
g_map <- find_MAP(g,
  optimizer = "BF", show_progress_bar = FALSE,
  return_probabilities = TRUE, save_all_perms = TRUE
)

get_probabilities_from_gipsmult(g_map)
}
\seealso{
\itemize{
\item \code{\link[=find_MAP]{find_MAP()}} - The \code{get_probabilities_from_gipsmult()}
is called on the output of
\code{find_MAP(return_probabilities = TRUE, save_all_perms = TRUE)}.
}
}
