% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-communes.R
\encoding{UTF-8}
\name{gisco_get_communes}
\alias{gisco_get_communes}
\title{Communes dataset}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/administrative-units}.
}
\usage{
gisco_get_communes(
  year = 2016,
  epsg = 4326,
  cache = deprecated(),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = "RG",
  country = NULL,
  ext = "shp"
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("communes",
"year",TRUE)}.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. These functions always
caches the result due to the size. See \strong{See Caching strategies} section
in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{spatialtype}{character string. Type of geometry to be returned. Options
available are:
\itemize{
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
\item \code{"LB"}: Labels - \code{POINT} object.
\item \code{"BN"}: Boundaries - \code{LINESTRING} object.
}

\strong{Note that} argument \code{country} would be only applied when
\code{spatialtype} is \code{"RG"} or \code{"LB"}.}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{ext}{character. Extension of the file (default \code{"shp"}). One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("communes",
"ext",TRUE)}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
This dataset shows pan European administrative boundaries down to commune
level. Communes are equivalent to Local Administrative Units,
see \code{\link[=gisco_get_lau]{gisco_get_lau()}}.
}
\details{
The Nomenclature of Territorial Units for Statistics (NUTS) and the LAU
nomenclature are hierarchical classifications of statistical regions that
together subdivide the EU economic territory into regions of five different
levels (NUTS 1, 2 and 3 and LAU , respectively, moving from larger to smaller
territorial units).

The dataset is based on EuroBoundaryMap from
\href{https://eurogeographics.org/}{EuroGeographics}. Geographical extent covers
the European Union 28, EFTA countries, and candidate countries. The scale of
the dataset is 1:100 000.

The LAU classification is not covered by any legislative act.
}
\section{Note}{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}

\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
ire_comm <- gisco_get_communes(spatialtype = "LB", country = "Ireland")

if (!is.null(ire_comm)) {
  library(ggplot2)

  ggplot(ire_comm) +
    geom_sf(shape = 21, col = "#009A44", size = 0.5) +
    labs(
      title = "Communes in Ireland",
      subtitle = "Year 2016",
      caption = gisco_attributions()
    ) +
    theme_void() +
    theme(text = element_text(
      colour = "#009A44",
      family = "serif", face = "bold"
    ))
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_lau]{gisco_get_lau()}}.

See \code{\link[=gisco_bulk_download]{gisco_bulk_download()}} to perform a bulk download of datasets.

Other administrative units datasets:
\code{\link{gisco_get_countries}()},
\code{\link{gisco_get_postal_codes}()}
}
\concept{admin}
