% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nested.glmnetr_251212.R
\name{summary.nested.glmnetr}
\alias{summary.nested.glmnetr}
\title{Summarize a nested.glmnetr() output object}
\usage{
\method{summary}{nested.glmnetr}(
  object,
  cvfit = FALSE,
  type = "lasso",
  pow = 2,
  printg1 = FALSE,
  digits = 4,
  call = NULL,
  onese = 0,
  table = 1,
  tuning = 0,
  width = 84,
  cal = 0,
  ...
)
}
\arguments{
\item{object}{a nested.glmnetr() output object.}

\item{cvfit}{default of FALSE to summarize fit of a cross validation informed 
relaxed lasso model fit, inferred by nested cross validation.  Option of TRUE 
will describe the cross validation informed relaxed lasso model itself.}

\item{type}{When cvfit is TRUE, one of c("lasso", "elastic", "ridge") to 
select for summarizing, with default of "lasso".}

\item{pow}{the power to which the average of correlations is to be raised.  Only 
applies to the "gaussian" model.  Default is 2 to yield R-square but can be on to 
show correlations.  Pow is ignored for the family of "cox" and "binomial".}

\item{printg1}{TRUE to also print out the fully penalized lasso beta, else to suppress.
Only applies to cvfit=TRUE.}

\item{digits}{digits for printing of deviances, linear calibration coefficients 
and agreement (concordances and R-squares).}

\item{call}{1 to print call used in generation of the object, 0 or NULL to not print}

\item{onese}{0 (default) to not include summary for 1se lasso fits in tables, 1 to include}

\item{table}{1 to print table to console, 0 to output the tabled information to a data frame}

\item{tuning}{1 to print tuning parameters, 0 (default) to not print}

\item{width}{character width of the text body preceding the performance 
measures which can be adjusted between 60 and 120.}

\item{cal}{1 print performance statistics for lasso 
models calibrated on training data, 2 to print performance statistics for 
lasso and random forest models calibrated on training data, 0 (default) to 
not print.  Note, despite any intuitive appeal these training data 
calibrated models may sometimes do rather poorly.}

\item{...}{Additional arguments passed to the summary function.}
}
\value{
- a nested cross validation fit summary, or a cross validation model summary.
}
\description{
Summarize the model fit from a nested.glmnetr() output object, i.e. the fit of 
a cross-validation informed relaxed lasso model fit, inferred by nested cross 
validation.  Else summarize the cross-validated model fit.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
fit3 = nested.glmnetr(xs, NULL, y_, event, family="cox", folds_n=3)  
summary(fit3)
}

}
\seealso{
\code{\link{nested.compare}} , \code{\link{nested.cis}} , \code{\link{summary.cv.glmnetr}} , \code{\link{roundperf}} , 
  \code{\link{plot.nested.glmnetr}} , \code{\link{calplot}} , \code{\link{nested.glmnetr}}
}
