\name{plotPower}
\alias{plotPower}
\title{A power plot for a  gsearly model}
\usage{plotPower(mod, xlim=NA, ylim=NA, xlab=NA, ylab=NA, title=NULL,
    col=c(1,2), lty=NA, pch=3, las=1, legpos=c("bottomright","topright"),
    xtype="theta", delta=seq(0,1,0.05), legstudy=NA, ...)}
\description{A power plot for a gsearly model.}
\arguments{
 \item{mod}{A gsearly model from function \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}} functions.}
 \item{xlim}{The \code{x} limits \code{c(x1, x2)} of the plot; default
   \code{NA}.}
 \item{ylim}{The \code{y} limits of the plot; default \code{NA}.}
 \item{xlab}{A label for the x axis; default depends on \code{xtype} setting
   such that if \code{"delta"}, then label is \code{"Standardized effect size"}
   or if \code{"theta"}, then label is \code{"Effect size"}.}
 \item{ylab}{A label for the \code{y} axis; default
   \code{"Cumulative boundary crossing probability"}.}
 \item{title}{A main title for the plot; default \code{NULL}.}
 \item{col}{Plotting colours for the lower and upper boundaries; default
   \code{c(1, 2)}.}
 \item{lty}{Line types, which should be a numeric vector of length equal to the
   number of looks (\code{mod$power$nlooks}); default \code{1:nlooks}.}
 \item{pch}{Plotting character or symbol for points; default 3.}
 \item{las}{A numeric value which is one of either 0, 1, 2 or 3; the style of
   axis labels, 0: always parallel to the axis, 1: always horizontal (default),
   2: always perpendicular to the axis, 3: always vertical.}
 \item{legpos}{Legend position is a vector of length 2 giving the positions of
   the legends (interims and probabilities), which are one of
   \code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"}, \code{"left"},
   \code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"right"} and
   \code{"center"}; default \code{"topleft"}.}
 \item{xtype}{X-axis options are either \code{"delta"} or \code{"theta"}, the
   former uses theta/sd (standardized effect size) and the latter theta;
   default \code{"theta"}.}
 \item{delta}{An ordered vector of values at which the probabilities are
   calculated. Smoother curves are obtained if the intervals between values are
   smaller; default \code{seq(0, 1, 0.05)}.}
 \item{legstudy}{A label for the study name in the legend; default is
   \code{"study"}.}
 \item{...}{Further arguments to plot function.}
}
\value{
 A plot of the selected type or a list consisting of the plotted line and
 interim point data.
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0010,0.0100,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(16,31), pow=0.8,
                   cmodel="exponential", sd=20, rho=0.75, theta=8, fp=fp, tn=tn)
 plotPower(rctdesign)

}
