% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gutenberg_cache.R
\name{gutenberg_cache_list}
\alias{gutenberg_cache_list}
\title{List files in the Gutenberg cache}
\usage{
gutenberg_cache_list(verbose = TRUE)
}
\arguments{
\item{verbose}{Whether to show the status message showing the cache directory path.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with the following columns:
\describe{
\item{title}{The title of the work.}
\item{author}{The author(s) of the work.}
\item{file}{The filename.}
\item{size_mb}{Size of the file in megabytes.}
\item{modified}{The last modification time.}
\item{path}{The file's absolute path.}
}
}
\description{
Provides a detailed list of files currently stored in the directory
returned by \code{\link[=gutenberg_cache_dir]{gutenberg_cache_dir()}}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# List all works in the currently set cache
gutenberg_cache_list()

# Suppress the directory path message
gutenberg_cache_list(verbose = FALSE)
\dontshow{\}) # examplesIf}
}
\keyword{cache}
