% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexContour.R
\name{hexContour}
\alias{hexContour}
\title{Generate contour for a hexagonal grid.}
\usage{
hexContour(hexDensity, levels)
}
\arguments{
\item{hexDensity}{hexDensity object to be contoured.}

\item{levels}{Numeric vector for which contour lines should be generated}
}
\value{
A list of x, y, and ID, for the contour line at each levels. 
ID indicates the different line segments making up the contour.
}
\description{
Algorithm is a modification of the meandering triangles as described in 
https://blog.bruce-hill.com/meandering-triangles to work with hexagons. See 
\link[isoband]{isolines} for details about the output.
}
\details{
This function is made to follow the same behaviour as
\link[isoband]{isolines}. A dedicated plotting function is in the work. 
Meanwhile, see example of how to plot the output with ggplot2's 
\link[ggplot2]{geom_path}.
}
\examples{
set.seed(133)
x=rnorm(200)
y=rnorm(200)
d = hexDensity(x=x,y=y,bandwidth=0.4)
cutoff=quantile(d@count,0.9)
lines = hexContour(d,cutoff)

library(ggplot2)
library(hexbin)
#plot against density
ggplot()+
  geom_point(
    aes(x=hcell2xy(d)$x,
        y=hcell2xy(d)$y,
        col=d@count)
 ) +
  scale_color_viridis_c()+
  geom_path(
    aes(
     x = lines[[1]]$x, y = lines[[1]]$y, group = lines[[1]]$id
    )
  )

#plot against data points
ggplot() +
  geom_point(
    aes(x=x,y=y)) +
  geom_path(
    aes(
      x = lines[[1]]$x, y = lines[[1]]$y, group = lines[[1]]$id
    )
  )
}
