% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{setRiver<-}
\alias{setRiver<-}
\alias{setRiver<-,WaterLevelDataFrame,character-method}
\alias{setRiver<--method}
\title{Set a WaterLevelDataFrame's slot river}
\usage{
setRiver(x) <- value

\S4method{setRiver}{WaterLevelDataFrame,character}(x) <- value
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{value}{a new value of class \code{character} for the \code{river}
slot. \code{value} has to have a length of one and has to be \strong{Elbe}
or \strong{Rhine}.}
}
\value{
The function above sets a new \code{value} for the slot \code{river}
  and returns an object of class \linkS4class{WaterLevelDataFrame}. Since
  \code{river} is a slot relevant for the computation of the
  \code{\link[base]{data.frame}} column \code{w}, \code{w} is set to
  \code{NA} and needs to be recomputed by functions like
  \code{\link{waterLevel}} or \code{\link{waterLevelPegelonline}}.
}
\description{
A function to set the slot \code{river} of an object of class
  \linkS4class{WaterLevelDataFrame}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(500, 501, 0.1))
setRiver(wldf) <- as.character("Rhine")

}
\seealso{
\code{\link{getRiver-method}}
}
