% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyreg2.R
\name{summary_hyreg2}
\alias{summary_hyreg2}
\title{model summary for hyreg2 objects}
\usage{
summary_hyreg2(object)
}
\arguments{
\item{object}{\code{modelobject} generated with \code{\link[=hyreg2]{hyreg2()}} or \code{\link[=hyreg2_het]{hyreg2_het()}}}
}
\value{
\code{summary} object of \code{\link[bbmle:mle2]{bbmle::mle2()}} model,  Please note
that the outputs for \code{sigma} and \code{theta} are on a log-scale and have to be transformed using \code{exp()}to get the correct estimated values.
}
\description{
get model parameters of model generated by \code{hyreg2} or \code{hyreg2_het}
}
\examples{

formula <- y ~  -1 + x1 + x2 + x3 | id
k <- 1
stv <- setNames(c(0.2,0,1,1,1),c(colnames(simulated_data_norm)[3:5],c("sigma","theta")))
control = list(iter.max = 1000, verbose = 4)
rm(counter)
mod <- hyreg2(formula = formula,
                    data =  simulated_data_norm,
                    type =  simulated_data_norm$type,
                    stv = stv,
                    k = k,
                    type_cont = "TTO",
                    type_dich = "DCE_A",
                    opt_method = "L-BFGS-B",
                    control = control,
                    latent = "both",
                    id_col = "id"
)
summary_hyreg2(mod)

}
\author{
Svenja Elkenkamp
}
