% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iRfcb-package.R
\docType{package}
\name{iRfcb-package}
\alias{iRfcb}
\alias{iRfcb-package}
\title{iRfcb: Tools for Managing Imaging FlowCytobot (IFCB) Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A comprehensive suite of tools for managing, processing, and analyzing data from the IFCB. I R FlowCytobot ('iRfcb') supports quality control, geospatial analysis, and preparation of IFCB data for publication in databases like \url{https://www.gbif.org}, \url{https://www.obis.org}, \url{https://emodnet.ec.europa.eu/en}, \url{https://shark.smhi.se/en/}, and \url{https://www.ecotaxa.org}. The package integrates with the MATLAB 'ifcb-analysis' tool, which is described in Sosik and Olson (2007) \doi{10.4319/lom.2007.5.204}, and provides features for working with raw, manually classified, and machine learning–classified image datasets. Key functionalities include image extraction, particle size distribution analysis, taxonomic data handling, and biomass concentration calculations, essential for plankton research.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://europeanifcbgroup.github.io/iRfcb/}
  \item \url{https://github.com/EuropeanIFCBGroup/iRfcb}
}

}
\author{
\strong{Maintainer}: Anders Torstensson \email{anders.torstensson@smhi.se} (\href{https://orcid.org/0000-0002-8283-656X}{ORCID}) (Swedish Meteorological and Hydrological Institute)

Other contributors:
\itemize{
  \item Kendra Hayashi (\href{https://orcid.org/0000-0003-1600-9504}{ORCID}) [contributor]
  \item Jamie Enslein [contributor]
  \item Raphael Kudela (\href{https://orcid.org/0000-0002-8640-1205}{ORCID}) [contributor]
  \item Alle Lie (\href{https://orcid.org/0009-0001-8709-4841}{ORCID}) [contributor]
  \item Jayme Smith (\href{https://orcid.org/0000-0002-9669-4427}{ORCID}) [contributor]
  \item DTO-BioFlow (Horizon Europe, HORIZON-MISS-2022-OCEAN-01-07) [funder]
  \item SBDI (Swedish Research Council, 2019-00242) [funder]
}

}
\keyword{internal}
