% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{clean_player_db}
\alias{clean_player_db}
\title{Clean and standardize football player data}
\usage{
clean_player_db(df)
}
\arguments{
\item{df}{A data frame containing raw football player data.
Must include at least columns \code{name}, \code{age},
and \code{market_value_est}.}
}
\value{
A data frame with cleaned and standardized player data.
}
\description{
This function converts character-based numeric fields into numeric
values and prepares player data for further analysis.
}
\details{
The function performs safe numeric conversion and does not remove
rows with missing values.
}
\examples{
df <- data.frame(
  name = c("Player A", "Player B"),
  age = c("21", "23"),
  market_value_est = c("€500k", "€750k"),
  club = c("Club A", "Club B"),
  league_country = c("Indonesia", "Indonesia"),
  stringsAsFactors = FALSE
)

clean_player_db(df)

}
