% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{clusterRank}
\alias{clusterRank}
\alias{CR}
\title{ClusterRank (CR)}
\usage{
clusterRank(
  graph,
  vids = V(graph),
  directed = FALSE,
  loops = TRUE,
  ncores = "default",
  verbose = FALSE
)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{directed}{Logical scalar, whether to directed graph is analyzed. This argument is ignored for undirected graphs.}

\item{loops}{Logical; whether the loop edges are also counted.}

\item{ncores}{Integer; the number of cores to be used for parallel processing. If ncores == "default" (default), the number of cores 
to be used will be the max(number of available cores) - 1. We recommend leaving ncores argument as is (ncores = "default").}

\item{verbose}{Logical; whether the accomplishment of different stages of the algorithm should be printed (default is FALSE).}
}
\value{
A numeric vector contaning the ClusterRank centrality scores for the selected vertices.
}
\description{
This function calculates the ClusterRank of input vertices and
works with both directed and undirected networks.
This function and all of its descriptions have been adapted from the centiserve package with
some minor modifications. ClusterRank is a local ranking algorithm which takes into account not only
the number of neighbors and the neighbors’ influences, but also the clustering coefficient.
}
\examples{
\dontrun{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
cr <- clusterRank(graph = My_graph, vids = GraphVertices, 
directed = FALSE, loops = TRUE, ncores = 1)
}
}
\seealso{
\code{\link[influential]{ivi}},
\code{\link[influential]{cent_network.vis}}

Other centrality functions: 
\code{\link{betweenness}()},
\code{\link{collective.influence}()},
\code{\link{h_index}()},
\code{\link{lh_index}()},
\code{\link{neighborhood.connectivity}()},
\code{\link{sirir}()}
}
\concept{centrality functions}
\keyword{clusterRank}
