% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery.R
\name{get_available_values}
\alias{get_available_values}
\title{Get all available values for all dimensions}
\usage{
get_available_values(dataset)
}
\arguments{
\item{dataset}{An istat_dataset object}
}
\value{
A named list where each element contains a tibble of available values
for that dimension
}
\description{
Uses the availableconstraint endpoint to get all valid values for each dimension.
This is more accurate than getting values from codelists as it reflects
actual data availability.
}
\examples{
\dontrun{
ds <- istat_dataset("139_176")
available <- get_available_values(ds)
available$FREQ  # Available frequency values
}
}
