% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_stats.R
\name{robustness_value}
\alias{robustness_value}
\alias{extreme_robustness_value}
\alias{xrv}
\alias{rv}
\alias{extreme_robustness_value.iv_fit}
\alias{robustness_value.iv_fit}
\title{Computes the (extreme) robustness value for IV}
\usage{
robustness_value(...)

extreme_robustness_value(...)

xrv(...)

rv(...)

\method{extreme_robustness_value}{iv_fit}(
  model,
  parm = "iv",
  q = 1,
  alpha = 0.05,
  min = TRUE,
  ...
)

\method{robustness_value}{iv_fit}(model, parm = "iv", q = 1, alpha = 0.05, min = TRUE, ...)
}
\arguments{
\item{...}{further arguments passed to or from other methods.}

\item{model}{an \code{\link{iv_fit}} model}

\item{parm}{parameter for which the robustness value is computed. Default is \code{iv}, meaning that the robustness value of the IV estimate is computed. Other options are to compute the robustness value of auxiliary estimates, such as the first stage (\code{fs}) or the reduced form (\code{rf}).}

\item{q}{percent change of the effect estimate that would be deemed problematic. Default is 1, which means a reduction (increase) of 100\% of the current effect estimate (bring estimate to zero). It has to be greater than zero.}

\item{alpha}{significance level.}

\item{min}{in many cases, researchers are interested in biases as large or larger than a certain amount (for instance, the strength of confounding to bring a positive estimate to zero or below). Setting \code{min = TRUE} (default) computes the robustness value for such cases. Setting \code{min = FALSE} computes the robustness value for a bias of exactly \code{q}.}
}
\value{
A numeric value with the (extreme) robustness value.
}
\description{
Computes robustness values for \code{\link{iv_fit}} objects, adapting the
robustness value definitions of \pkg{sensemakr} to instrumental variables as
described in Cinelli and Hazlett (2025).
For \code{parm = "iv"}, returns robustness values for the IV estimate; for
\code{parm = "fs"} or \code{parm = "rf"}, dispatches to \pkg{sensemakr}
methods on the corresponding \code{\link{lm}} models.
}
\examples{
data("card")
y <- card$lwage
d <- card$educ
z <- card$nearc4
x <- model.matrix( ~ exper + expersq + black + south + smsa + reg661 + reg662 +
                     reg663 + reg664 + reg665+ reg666 + reg667 + reg668 + smsa66,
                   data = card)
card.fit <- iv_fit(y, d, z, x)

# robustness value of the IV estimate
rv(card.fit)

# extreme robustness value
xrv(card.fit)

# robustness values for first-stage and reduced-form
rv(card.fit, parm = "fs")
rv(card.fit, parm = "rf")

}
\references{
Cinelli, C. and Hazlett, C. (2025), "An Omitted Variable Bias Framework for Sensitivity Analysis of Instrumental Variables." Biometrika. \doi{10.1093/biomet/asaf004}
}
