% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{opts}
\alias{opts}
\alias{set}
\alias{get}
\alias{reset}
\title{Options for the justifier package}
\format{
An object of class \code{list} of length 4.
}
\usage{
opts
}
\description{
The \code{justifier::opts} object contains three functions to set, get, and reset
options used by the escalc package. Use \code{justifier::opts$set} to set options,
\code{justifier::opts$get} to get options, or \code{justifier::opts$reset} to reset specific or
all options to their default values.
}
\details{
If you use justifier to programmatically document your decisions in an
R file, there is one option that you common use: \code{workspace_id} and
\code{workspace_option_name}

It is normally not necessary to get or set \code{justifier} options.

The following arguments can be passed:

\describe{
\item{...}{For \code{justifier::opts$set}, the dots can be used to specify the options
to set, in the format \code{option = value}, for example,
\code{EFFECTSIZE_POINTESTIMATE_NAME_IN_DF = "\\n"}. For
\code{justifier::opts$reset}, a list of options to be reset can be passed.}
\item{option}{For \code{justifier::opts$set}, the name of the option to set.}
\item{default}{For \code{justifier::opts$get}, the default value to return if the
option has not been manually specified.}
}

The following options can be set:

\describe{

\item{regExReplacements}{Default regex replacements when sanitizing for DiagrammeR}

\item{weight_fieldName}{When creating the diagram showing the justification for a
decision, the name of the field with the weight.}

\item{negWeight_color}{When creating the diagram showing the justification for a
decision, the colour to use for edges with negative weights}

\item{posWeight_color}{When creating the diagram showing the justification for a
decision, the colour to use for edges with positive weights}

\item{node_color}{When creating the diagram showing the justification for a
decision, the color for nodes}

\item{edge_color}{When creating the diagram showing the justification for a
decision, the color for edges}

\item{penwidth}{When creating the diagram showing the justification for a
decision, the pen widht}

\item{workspace_id}{The default identifier for the workspace (when
nothing else is specified)}

\item{workspace}{The name of the default workspace}

\item{silent}{Whether to be chatty or silent}

}
}
\examples{
### Get the default 'silent' setting
justifier::opts$get('silent');

### Set to FALSE
justifier::opts$set(silent = FALSE);

### Check that it worked
justifier::opts$get('silent');

### Reset this option to its default value
justifier::opts$reset('silent');

### Check that the reset worked, too
justifier::opts$get('silent');

}
\keyword{datasets}
