% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths.R
\name{bw_tt_pi}
\alias{bw_tt_pi}
\alias{bw_tt_cv}
\title{Nearest-neighbor bandwidth selection for the tapered transformation estimator}
\usage{
bw_tt_pi(udata, rho.add = TRUE)

bw_tt_cv(udata, rho.add = T)
}
\arguments{
\item{udata}{data.}

\item{rho.add}{logical; whether a rotation (correlation) parameter shall be
included.}
}
\value{
Optimal smoothing parameters as in Wen and Wu (2015): a numeric
vector of length 4; entries are \eqn{(h, \rho, \theta_1, \theta_2)}.
}
\description{
The smoothing parameters are selected by the method of Wen and Wu (2015).
}
\references{
Wen, K. and Wu, X. (2018).
Transformation-Kernel Estimation of Copula Densities
Journal of Business & Economic Statistics, 38(1), 148–164.
}
\author{
Kuangyu Wen
}
