% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{fitted.kdecopula}
\alias{fitted.kdecopula}
\title{Extract fitted values from a \code{kdecop()} fits.}
\usage{
\method{fitted}{kdecopula}(object, what = "pdf", ...)
}
\arguments{
\item{object}{an object of class \code{kdecopula}.}

\item{what}{what to predict, one of \code{c("pdf", "cdf", "hfunc1", "hfunc2", "hinv1", "hinv2")}.}

\item{...}{unused.}
}
\description{
Simply calls \code{predict(object, object$udata, what)}.
}
\examples{
data(wdbc)
udat <- apply(wdbc[, -1], 2, function(x) rank(x) / (length(x) + 1))
fit <- kdecop(udat[, 5:6])

all.equal(fitted(fit), predict(fit, fit$udata))
}
\seealso{
\code{predict.kdecopula()}
}
