% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_one_hot_iou}
\alias{metric_one_hot_iou}
\title{Computes the Intersection-Over-Union metric for one-hot encoded labels.}
\usage{
metric_one_hot_iou(
  ...,
  num_classes,
  target_class_ids,
  name = NULL,
  dtype = NULL,
  ignore_class = NULL,
  sparse_y_pred = FALSE,
  axis = -1L
)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{num_classes}{The possible number of labels the prediction task can have.}

\item{target_class_ids}{A list or list of target class ids for which the
metric is returned. To compute IoU for a specific class, a list
(or list) of a single id value should be provided.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}

\item{ignore_class}{Optional integer. The ID of a class to be ignored during
metric computation. This is useful, for example, in segmentation
problems featuring a "void" class (commonly -1 or 255) in
segmentation maps. By default (\code{ignore_class=NULL}), all classes are
considered.}

\item{sparse_y_pred}{Whether predictions are encoded using integers or
dense floating point vectors. If \code{FALSE}, the \code{argmax} function
is used to determine each sample's most likely associated label.}

\item{axis}{(Optional) The dimension containing the logits. Defaults to \code{-1}.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{iou <- true_positives / (true_positives + false_positives + false_negatives)
}\if{html}{\out{</div>}}

Intersection-Over-Union is a common evaluation metric for semantic image
segmentation.

To compute IoUs, the predictions are accumulated in a confusion matrix,
weighted by \code{sample_weight} and the metric is then calculated from it.

If \code{sample_weight} is \code{NULL}, weights default to 1.
Use \code{sample_weight} of 0 to mask values.

This class can be used to compute IoU for multi-class classification tasks
where the labels are one-hot encoded (the last axis should have one
dimension per class). Note that the predictions should also have the same
shape. To compute the IoU, first the labels and predictions are converted
back into integer format by taking the argmax over the class axis. Then the
same computation steps as for the base \code{IoU} class apply.

Note, if there is only one channel in the labels and predictions, this class
is the same as class \code{IoU}. In this case, use \code{IoU} instead.

Also, make sure that \code{num_classes} is equal to the number of classes in the
data, to avoid a "labels out of bound" error when the confusion matrix is
computed.
}
\section{Examples}{
Standalone usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- rbind(c(0, 0, 1),
                c(1, 0, 0),
                c(0, 1, 0),
                c(1, 0, 0))
y_pred <- rbind(c(0.2, 0.3, 0.5),
                c(0.1, 0.2, 0.7),
                c(0.5, 0.3, 0.1),
                c(0.1, 0.4, 0.5))
sample_weight <- c(0.1, 0.2, 0.3, 0.4)

m <- metric_one_hot_iou(num_classes = 3, target_class_ids = c(0, 2))
m$update_state(y_true = y_true,
               y_pred = y_pred,
               sample_weight = 10*sample_weight)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(
## [[0 0 6]
##  [3 0 0]
##  [0 0 1]], shape=(3, 3), dtype=int64)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.071428575, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model \%>\% compile(
  optimizer = 'sgd',
  loss = 'mse',
  metrics = list(metric_one_hot_iou(
    num_classes = 3L,
    target_class_id = list(1L)
  ))
)
}\if{html}{\out{</div>}}
}

\seealso{
Other iou metrics: \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{iou metrics}
\concept{metrics}
