% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_bandwidth.r
\name{cv_bandwidth}
\alias{cv_bandwidth}
\title{Cross-Validation function for bandwidth parameter selection of discrete
kernel}
\usage{
cv_bandwidth(
  kernel = c("optimal", "triang", "epanech", "binomial"),
  v,
  h,
  k = NULL
)
}
\arguments{
\item{kernel}{the type of kernel. Currently supported kernels are limited to:
"optimal", "triang", "epanech" and "binomial"}

\item{v}{the vector of observations}

\item{h}{the list of bandwidth parameters to test in cross validation}

\item{k}{Optional: the integer (positive) parameter that defined the support
of the kernel function (corresponds to parameter 'a' for triangular
kernel). It is only used for optimal and triangular kernel}
}
\value{
the optimal bandwidth value
}
\description{
Cross-Validation function for bandwidth parameter selection of discrete
kernel
}
\examples{
n <- 250
mu <- 2 # Mean
y <- sort(rpois(n, mu))
# kernel support parameter
k <- 1
H <- seq((max(y) - min(y)) / 200, (max(y) - min(y)) / 2, length.out = 50)
hcv <- cv_bandwidth(kernel = "optimal", y, h = H, k = k)
}
